<?php
// Front controller that serves the original SPA build, but through PHP.
// This keeps *all* JS functionality from the uploaded package.

$base = rtrim(dirname($_SERVER['SCRIPT_NAME'] ?? ''), '/\\');
if ($base === '.' || $base === '/') {
    $base = '';
}
$baseHref = ($base === '') ? '/' : ($base . '/');
?><!doctype html>
<html lang="en">
  <head>
    <meta charset="UTF-8" />
    <base href="<?php echo htmlspecialchars($baseHref, ENT_QUOTES, 'UTF-8'); ?>">
    <link rel="icon" type="image/x-icon" href="favicon.ico" />
    <link rel="icon" type="image/png" href="favicon.png" />
    <meta name="viewport" content="width=device-width, initial-scale=1.0" />
    <title>VeRomTec</title>

    <!-- Original bundled assets -->
    <script type="module" crossorigin src="assets/index-DUwfuP_v.js"></script>
    <link rel="stylesheet" crossorigin href="assets/index-CFCfUYc_.css">

    <!-- Recipe-style color palette overrides -->
    <link rel="stylesheet" href="theme-overrides.css?v=1">
  </head>
  <body>
    <div id="root"></div>
  </body>
</html>
