var u=`{
  "connect_wallet": {
    "label": "Подключить кошелек",
    "wrong_network": {
      "label": "Неправильная сеть"
    }
  },
  "intro": {
    "title": "Что такое кошелек?",
    "description": "Кошелек используется для отправки, получения, хранения и отображения цифровых активов. Это также новый способ входа в систему, без необходимости создания новых учетных записей и паролей на каждом сайте.",
    "digital_asset": {
      "title": "Дом для ваших цифровых активов",
      "description": "Кошельки используются для отправки, получения, хранения и отображения цифровых активов, таких как Ethereum и NFT."
    },
    "login": {
      "title": "Новый способ входа в систему",
      "description": "Вместо создания новых аккаунтов и паролей на каждом сайте, просто подключите ваш кошелек."
    },
    "get": {
      "label": "Получить кошелек"
    },
    "learn_more": {
      "label": "Узнать больше"
    }
  },
  "sign_in": {
    "label": "Проверьте ваш аккаунт",
    "description": "Чтобы завершить подключение, вы должны подписать сообщение в вашем кошельке, чтобы подтвердить, что вы являетесь владельцем этого аккаунта.",
    "message": {
      "send": "Отправить сообщение",
      "preparing": "Подготовка сообщения...",
      "cancel": "Отмена",
      "preparing_error": "Ошибка при подготовке сообщения, пожалуйста, попробуйте снова!"
    },
    "signature": {
      "waiting": "Ожидание подписи...",
      "verifying": "Проверка подписи...",
      "signing_error": "Ошибка при подписании сообщения, пожалуйста, попробуйте снова!",
      "verifying_error": "Ошибка при проверке подписи, пожалуйста, попробуйте снова!",
      "oops_error": "Ой, что-то пошло не так!"
    }
  },
  "connect": {
    "label": "Подключить",
    "title": "Подключить кошелек",
    "new_to_ethereum": {
      "description": "Впервые столкнулись с кошельками Ethereum?",
      "learn_more": {
        "label": "Узнать больше"
      }
    },
    "learn_more": {
      "label": "Узнать больше"
    },
    "recent": "Недавние",
    "status": {
      "opening": "Открывается %{wallet}...",
      "connecting": "Подключение",
      "connect_mobile": "Продолжить в %{wallet}",
      "not_installed": "%{wallet} не установлен",
      "not_available": "%{wallet} не доступен",
      "confirm": "Подтвердите подключение в расширении",
      "confirm_mobile": "Принять запрос на подключение в кошельке"
    },
    "secondary_action": {
      "get": {
        "description": "У вас нет %{wallet}?",
        "label": "ПОЛУЧИТЬ"
      },
      "install": {
        "label": "УСТАНОВИТЬ"
      },
      "retry": {
        "label": "ПОВТОРИТЬ"
      }
    },
    "walletconnect": {
      "description": {
        "full": "Нужен официальный модальный окно WalletConnect?",
        "compact": "Нужен модальный окно WalletConnect?"
      },
      "open": {
        "label": "ОТКРЫТЬ"
      }
    }
  },
  "connect_scan": {
    "title": "Сканировать с помощью %{wallet}",
    "fallback_title": "Сканировать с помощью вашего телефона"
  },
  "connector_group": {
    "installed": "Установлено",
    "recommended": "Рекомендуемые",
    "other": "Другие",
    "popular": "Популярные",
    "more": "Больше",
    "others": "Другие"
  },
  "get": {
    "title": "Получить кошелек",
    "action": {
      "label": "ПОЛУЧИТЬ"
    },
    "mobile": {
      "description": "Мобильный кошелек"
    },
    "extension": {
      "description": "Расширение для браузера"
    },
    "mobile_and_extension": {
      "description": "Мобильный кошелек и расширение"
    },
    "mobile_and_desktop": {
      "description": "Мобильный и настольный кошелек"
    },
    "looking_for": {
      "title": "Не то, что вы ищете?",
      "mobile": {
        "description": "Выберите кошелек на главном экране, чтобы начать работу с другим провайдером кошелька."
      },
      "desktop": {
        "compact_description": "Выберите кошелек на главном экране, чтобы начать работу с другим провайдером кошелька.",
        "wide_description": "Выберите кошелек слева, чтобы начать работу с другим провайдером кошелька."
      }
    }
  },
  "get_options": {
    "title": "Начните с %{wallet}",
    "short_title": "Получить %{wallet}",
    "mobile": {
      "title": "%{wallet} для мобильных",
      "description": "Используйте мобильный кошелек для исследования мира Ethereum.",
      "download": {
        "label": "Скачать приложение"
      }
    },
    "extension": {
      "title": "%{wallet} для %{browser}",
      "description": "Доступ к вашему кошельку прямо из вашего любимого веб-браузера.",
      "download": {
        "label": "Добавить в %{browser}"
      }
    },
    "desktop": {
      "title": "%{wallet} для %{platform}",
      "description": "Получите доступ к вашему кошельку нативно со своего мощного рабочего стола.",
      "download": {
        "label": "Добавить в %{platform}"
      }
    }
  },
  "get_mobile": {
    "title": "Установить %{wallet}",
    "description": "Отсканируйте на своем телефоне для скачивания на iOS или Android",
    "continue": {
      "label": "Продолжить"
    }
  },
  "get_instructions": {
    "mobile": {
      "connect": {
        "label": "Подключить"
      },
      "learn_more": {
        "label": "Узнать больше"
      }
    },
    "extension": {
      "refresh": {
        "label": "Обновить"
      },
      "learn_more": {
        "label": "Узнать больше"
      }
    },
    "desktop": {
      "connect": {
        "label": "Подключить"
      },
      "learn_more": {
        "label": "Узнать больше"
      }
    }
  },
  "chains": {
    "title": "Переключить сети",
    "wrong_network": "Обнаружена неверная сеть, переключитесь или отключитесь для продолжения.",
    "confirm": "Подтвердить в кошельке",
    "switching_not_supported": "Ваш кошелек не поддерживает переключение сетей с %{appName}. Попробуйте переключить сети из вашего кошелька.",
    "switching_not_supported_fallback": "Ваш кошелек не поддерживает переключение сетей из этого приложения. Попробуйте переключить сети из вашего кошелька.",
    "disconnect": "Отключить",
    "connected": "Подключено"
  },
  "profile": {
    "disconnect": {
      "label": "Отключить"
    },
    "copy_address": {
      "label": "Скопировать адрес",
      "copied": "Скопировано!"
    },
    "explorer": {
      "label": "Посмотреть больше в эксплорере"
    },
    "transactions": {
      "description": "%{appName} транзакции появятся здесь...",
      "description_fallback": "Ваши транзакции появятся здесь...",
      "recent": {
        "title": "Недавние транзакции"
      },
      "clear": {
        "label": "Очистить все"
      }
    }
  },
  "wallet_connectors": {
    "argent": {
      "qr_code": {
        "step1": {
          "description": "Добавьте Argent на домашний экран для более быстрого доступа к вашему кошельку.",
          "title": "Откройте приложение Argent"
        },
        "step2": {
          "description": "Создайте кошелек и имя пользователя или импортируйте существующий кошелек.",
          "title": "Создать или Импортировать кошелек"
        },
        "step3": {
          "description": "После сканирования появится запрос на подключение для подключения вашего кошелька.",
          "title": "Нажмите кнопку Сканировать QR"
        }
      }
    },
    "berasig": {
      "extension": {
        "step1": {
          "title": "Установите расширение BeraSig",
          "description": "Мы рекомендуем закрепить BeraSig на вашей панели задач для более удобного доступа к вашему кошельку."
        },
        "step2": {
          "title": "Создать кошелек",
          "description": "Обязательно сделайте резервную копию вашего кошелька с использованием безопасного метода. Никогда не делитесь своей секретной фразой с кем-либо."
        },
        "step3": {
          "title": "Обновите ваш браузер",
          "description": "После настройки вашего кошелька, нажмите ниже, чтобы обновить браузер и загрузить расширение."
        }
      }
    },
    "best": {
      "qr_code": {
        "step1": {
          "title": "Откройте приложение Best Wallet",
          "description": "Добавьте приложение Best Wallet на главный экран для быстрого доступа к вашему кошельку."
        },
        "step2": {
          "title": "Создать или Импортировать кошелек",
          "description": "Создайте новый кошелек или импортируйте существующий."
        },
        "step3": {
          "title": "Нажмите на иконку QR и отсканируйте",
          "description": "Нажмите на иконку QR на главном экране, отсканируйте код и подтвердите запрос на подключение."
        }
      }
    },
    "bifrost": {
      "qr_code": {
        "step1": {
          "description": "Мы рекомендуем добавить кошелек Bifrost на ваш начальный экран для более быстрого доступа.",
          "title": "Откройте приложение Bifrost Wallet"
        },
        "step2": {
          "description": "Создайте или импортируйте кошелек, используя вашу фразу восстановления.",
          "title": "Создать или импортировать кошелек"
        },
        "step3": {
          "description": "После сканирования появится запрос на подключение вашего кошелька.",
          "title": "Нажмите кнопку сканирования"
        }
      }
    },
    "bitget": {
      "qr_code": {
        "step1": {
          "description": "Мы рекомендуем добавить Bitget Wallet на ваш экран для более быстрого доступа.",
          "title": "Откройте приложение Bitget Wallet"
        },
        "step2": {
          "description": "Обязательно сделайте резервную копию вашего кошелька с использованием безопасного метода. Никогда не делитесь своей секретной фразой с кем-либо.",
          "title": "Создать или импортировать кошелек"
        },
        "step3": {
          "description": "После сканирования появится запрос на подключение вашего кошелька.",
          "title": "Нажмите кнопку сканирования"
        }
      },
      "extension": {
        "step1": {
          "description": "Мы рекомендуем закрепить Bitget Wallet на панели задач для более быстрого доступа к вашему кошельку.",
          "title": "Установите расширение Bitget Wallet"
        },
        "step2": {
          "description": "Обязательно сохраните резервную копию вашего кошелька с помощью надёжного метода. Никогда не делитесь своей секретной фразой с кем-либо.",
          "title": "Создать или Импортировать кошелек"
        },
        "step3": {
          "description": "После настройки вашего кошелька, нажмите ниже, чтобы обновить браузер и загрузить расширение.",
          "title": "Обновите ваш браузер"
        }
      }
    },
    "bitski": {
      "extension": {
        "step1": {
          "description": "Мы рекомендуем прикрепить Bitski к вашей панели задач для более быстрого доступа к вашему кошельку.",
          "title": "Установите расширение Bitski"
        },
        "step2": {
          "description": "Обязательно сохраните резервную копию вашего кошелька с использованием безопасного метода. Никогда не делитесь своей секретной фразой с кем-либо.",
          "title": "Создать кошелек или Импортировать кошелек"
        },
        "step3": {
          "description": "После того как вы настроите свой кошелек, нажмите ниже, чтобы обновить браузер и загрузить расширение.",
          "title": "Обновите ваш браузер"
        }
      }
    },
    "bitverse": {
      "qr_code": {
        "step1": {
          "title": "Откройте приложение Bitverse Wallet",
          "description": "Добавьте Bitverse Wallet на главный экран для более быстрого доступа к вашему кошельку."
        },
        "step2": {
          "title": "Создать или Импортировать кошелек",
          "description": "Создайте новый кошелек или импортируйте существующий."
        },
        "step3": {
          "title": "Нажмите на иконку QR и отсканируйте",
          "description": "Нажмите на иконку QR на главном экране, отсканируйте код и подтвердите запрос на подключение."
        }
      }
    },
    "bloom": {
      "desktop": {
        "step1": {
          "title": "Откройте приложение Bloom Wallet",
          "description": "Мы рекомендуем добавить Bloom Wallet на домашний экран для более быстрого доступа."
        },
        "step2": {
          "description": "Создайте или импортируйте кошелек, используя вашу фразу восстановления.",
          "title": "Создать или Импортировать кошелек"
        },
        "step3": {
          "description": "После того как у вас появится кошелек, нажмите на 'Connect', чтобы подключиться через Bloom. В приложении появится запрос на подключение, который вам нужно будет подтвердить.",
          "title": "Нажмите на 'Connect'"
        }
      }
    },
    "bybit": {
      "qr_code": {
        "step1": {
          "description": "Рекомендуем добавить Bybit на главный экран для более быстрого доступа к вашему кошельку.",
          "title": "Откройте приложение Bybit"
        },
        "step2": {
          "description": "Вы можете легко сделать резервную копию вашего кошелька, используя нашу функцию резервного копирования на вашем телефоне.",
          "title": "Создать или Импортировать кошелек"
        },
        "step3": {
          "description": "После сканирования появится запрос на подключение для подключения вашего кошелька.",
          "title": "Нажмите кнопку сканирования"
        }
      },
      "extension": {
        "step1": {
          "description": "Кликните в верхнем правом углу вашего браузера и закрепите кошелек Bybit для удобства доступа.",
          "title": "Установите расширение кошелька Bybit"
        },
        "step2": {
          "description": "Создайте новый кошелек или импортируйте существующий.",
          "title": "Создайте или импортируйте кошелек"
        },
        "step3": {
          "description": "После настройки кошелька Bybit, нажмите ниже, чтобы обновить браузер и загрузить расширение.",
          "title": "Обновите ваш браузер"
        }
      }
    },
    "binance": {
      "qr_code": {
        "step1": {
          "description": "Мы рекомендуем добавить Binance на ваш экран начальной страницы для более быстрого доступа к вашему кошельку.",
          "title": "Откройте приложение Binance"
        },
        "step2": {
          "description": "Вы можете легко сделать резервную копию вашего кошелька, используя нашу функцию резервного копирования на вашем телефоне.",
          "title": "Создать или Импортировать кошелек"
        },
        "step3": {
          "description": "После сканирования появится запрос на подключение для подключения вашего кошелька.",
          "title": "Нажмите кнопку WalletConnect"
        }
      }
    },
    "coin98": {
      "qr_code": {
        "step1": {
          "description": "Мы рекомендуем добавить Coin98 Wallet на ваш главный экран для более быстрого доступа к вашему кошельку.",
          "title": "Откройте приложение Coin98 Wallet"
        },
        "step2": {
          "description": "Вы можете легко сделать резервную копию вашего кошелька, используя нашу функцию резервного копирования на вашем телефоне.",
          "title": "Создать или импортировать кошелек"
        },
        "step3": {
          "description": "После сканирования для вас появится запрос на подключение, чтобы подключить ваш кошелек.",
          "title": "Нажмите кнопку WalletConnect"
        }
      },
      "extension": {
        "step1": {
          "description": "Нажмите в верхнем правом углу вашего браузера и закрепите Coin98 Wallet для удобного доступа.",
          "title": "Установите расширение Coin98 Wallet"
        },
        "step2": {
          "description": "Создайте новый кошелек или импортируйте существующий.",
          "title": "Создайте или импортируйте кошелек"
        },
        "step3": {
          "description": "После того как вы настроите Кошелек Coin98, нажмите ниже, чтобы обновить браузер и загрузить расширение.",
          "title": "Обновите ваш браузер"
        }
      }
    },
    "coinbase": {
      "qr_code": {
        "step1": {
          "description": "Мы рекомендуем добавить Coinbase Wallet на ваш экран начала для более быстрого доступа.",
          "title": "Откройте приложение Coinbase Wallet"
        },
        "step2": {
          "description": "Вы легко можете сделать резервную копию вашего кошелька, используя функцию облачного резервного копирования.",
          "title": "Создать или Импортировать кошелек"
        },
        "step3": {
          "description": "После сканирования появится запрос на подключение для подключения вашего кошелька.",
          "title": "Нажмите кнопку сканирования"
        }
      },
      "extension": {
        "step1": {
          "description": "Мы рекомендуем закрепить Coinbase Wallet на вашей панели задач для более быстрого доступа к вашему кошельку.",
          "title": "Установите расширение Coinbase Wallet"
        },
        "step2": {
          "description": "Обязательно сделайте резервную копию вашего кошелька с использованием безопасного метода. Никогда не делитесь своей секретной фразой с кем-либо.",
          "title": "Создать или Импортировать кошелек"
        },
        "step3": {
          "description": "После настройки вашего кошелька, нажмите ниже, чтобы обновить браузер и загрузить расширение.",
          "title": "Обновите ваш браузер"
        }
      }
    },
    "compass": {
      "extension": {
        "step1": {
          "description": "Мы рекомендуем закрепить Compass Wallet на вашей панели задач для более быстрого доступа к вашему кошельку.",
          "title": "Установите расширение Compass Wallet"
        },
        "step2": {
          "description": "Обязательно сделайте резервную копию вашего кошелька с использованием безопасного метода. Никогда не делитесь своей секретной фразой с кем-либо.",
          "title": "Создать или Импортировать кошелек"
        },
        "step3": {
          "description": "После настройки вашего кошелька, нажмите ниже, чтобы обновить браузер и загрузить расширение.",
          "title": "Обновите ваш браузер"
        }
      }
    },
    "core": {
      "qr_code": {
        "step1": {
          "description": "Мы рекомендуем добавить Core на ваш экран быстрого доступа для ускоренного доступа к вашему кошельку.",
          "title": "Открыть приложение Core"
        },
        "step2": {
          "description": "Вы можете легко создать резервную копию вашего кошелька, используя нашу функцию резервного копирования на вашем телефоне.",
          "title": "Создать или Импортировать кошелек"
        },
        "step3": {
          "description": "После сканирования появится запрос на подключение, чтобы вы могли подключить ваш кошелек.",
          "title": "Нажмите кнопку WalletConnect"
        }
      },
      "extension": {
        "step1": {
          "description": "Мы рекомендуем закрепить Core на панели задач для более быстрого доступа к вашему кошельку.",
          "title": "Установите расширение Core"
        },
        "step2": {
          "description": "Обязательно создайте резервную копию вашего кошелька с использованием безопасного метода. Никогда не делитесь вашей секретной фразой с кем-либо.",
          "title": "Создать или Импортировать кошелек"
        },
        "step3": {
          "description": "Как только вы настроите ваш кошелек, нажмите ниже, чтобы обновить браузер и загрузить расширение.",
          "title": "Обновите ваш браузер"
        }
      }
    },
    "fox": {
      "qr_code": {
        "step1": {
          "description": "Мы рекомендуем поместить FoxWallet на ваш экран начального экрана для более быстрого доступа.",
          "title": "Откройте приложение FoxWallet"
        },
        "step2": {
          "description": "Обязательно сделайте резервное копирование вашего кошелька с использованием безопасного метода. Никогда не делитесь своей секретной фразой с кем-либо.",
          "title": "Создать или Импортировать кошелек"
        },
        "step3": {
          "description": "После сканирования появится приглашение для подключения вашего кошелька.",
          "title": "Нажмите кнопку сканирования"
        }
      }
    },
    "frontier": {
      "qr_code": {
        "step1": {
          "description": "Мы рекомендуем установить Frontier Wallet на экран вашего смартфона для более быстрого доступа.",
          "title": "Откройте приложение Frontier Wallet"
        },
        "step2": {
          "description": "Обязательно сделайте резервное копирование вашего кошелька с использованием безопасного метода. Никогда не делитесь своей секретной фразой с кем-либо.",
          "title": "Создать или Импортировать кошелек"
        },
        "step3": {
          "description": "После сканирования появится запрос на подключение кошелька.",
          "title": "Нажмите кнопку сканирования"
        }
      },
      "extension": {
        "step1": {
          "description": "Мы рекомендуем прикрепить кошелек Frontier к панели задач для более быстрого доступа к вашему кошельку.",
          "title": "Установите расширение кошелька Frontier"
        },
        "step2": {
          "description": "Обязательно сделайте резервную копию своего кошелька с использованием надежного метода. Никогда не делитесь своей секретной фразой с кем-либо.",
          "title": "Создать или импортировать кошелек"
        },
        "step3": {
          "description": "После настройки вашего кошелька нажмите ниже, чтобы обновить браузер и загрузить расширение.",
          "title": "Обновите ваш браузер"
        }
      }
    },
    "im_token": {
      "qr_code": {
        "step1": {
          "title": "Откройте приложение imToken",
          "description": "Поместите приложение imToken на главный экран для более быстрого доступа к вашему кошельку."
        },
        "step2": {
          "title": "Создать или импортировать кошелек",
          "description": "Создайте новый кошелек или импортируйте существующий."
        },
        "step3": {
          "title": "Нажмите на иконку сканера в верхнем правом углу",
          "description": "Выберите Новое соединение, затем отсканируйте QR-код и подтвердите запрос на соединение."
        }
      }
    },
    "iopay": {
      "qr_code": {
        "step1": {
          "description": "Мы рекомендуем разместить ioPay на вашем домашнем экране для более быстрого доступа к вашему кошельку.",
          "title": "Откройте приложение ioPay"
        },
        "step2": {
          "description": "Вы можете легко сделать резервную копию вашего кошелька, используя нашу функцию резервного копирования на вашем телефоне.",
          "title": "Создать или Импортировать кошелек"
        },
        "step3": {
          "description": "После сканирования появится запрос на подключение для подключения вашего кошелька.",
          "title": "Нажмите кнопку WalletConnect"
        }
      }
    },
    "kaikas": {
      "extension": {
        "step1": {
          "description": "Рекомендуем закрепить Kaikas на панели задач для более быстрого доступа к вашему кошельку.",
          "title": "Установите расширение Kaikas"
        },
        "step2": {
          "description": "Обязательно сделайте резервную копию вашего кошелька с использованием безопасного метода. Никогда не делитесь своей секретной фразой с кем-либо.",
          "title": "Создать или Импортировать кошелек"
        },
        "step3": {
          "description": "После настройки вашего кошелька, нажмите ниже, чтобы обновить браузер и загрузить расширение.",
          "title": "Обновите ваш браузер"
        }
      },
      "qr_code": {
        "step1": {
          "title": "Откройте приложение Kaikas",
          "description": "Добавьте приложение Kaikas на главный экран для более быстрого доступа к вашему кошельку."
        },
        "step2": {
          "title": "Создать или Импортировать кошелек",
          "description": "Создайте новый кошелек или импортируйте существующий."
        },
        "step3": {
          "title": "Нажмите на иконку сканера в верхнем правом углу",
          "description": "Выберите Новое соединение, затем отсканируйте QR-код и подтвердите запрос на соединение."
        }
      }
    },
    "kaia": {
      "extension": {
        "step1": {
          "description": "Мы рекомендуем закрепить Kaia на панели задач для более быстрого доступа к вашему кошельку.",
          "title": "Установите расширение Kaia"
        },
        "step2": {
          "description": "Обязательно сделайте резервную копию вашего кошелька с использованием безопасного метода. Никогда не делитесь своей секретной фразой с кем-либо.",
          "title": "Создать или Импортировать кошелек"
        },
        "step3": {
          "description": "После настройки вашего кошелька, нажмите ниже, чтобы обновить браузер и загрузить расширение.",
          "title": "Обновите ваш браузер"
        }
      },
      "qr_code": {
        "step1": {
          "title": "Откройте приложение Kaia",
          "description": "Добавьте приложение Kaia на главный экран для более быстрого доступа к вашему кошельку."
        },
        "step2": {
          "title": "Создать или Импортировать кошелек",
          "description": "Создайте новый кошелек или импортируйте существующий."
        },
        "step3": {
          "title": "Нажмите на иконку сканера в верхнем правом углу",
          "description": "Выберите Новое соединение, затем отсканируйте QR-код и подтвердите запрос на соединение."
        }
      }
    },
    "kraken": {
      "qr_code": {
        "step1": {
          "title": "Откройте приложение Kraken Wallet",
          "description": "Добавьте Kraken Wallet на ваш главный экран для более быстрого доступа к вашему кошельку."
        },
        "step2": {
          "title": "Создать или Импортировать кошелек",
          "description": "Создайте новый кошелек или импортируйте существующий."
        },
        "step3": {
          "title": "Нажмите на иконку QR и отсканируйте",
          "description": "Нажмите на иконку QR на главном экране, отсканируйте код и подтвердите запрос на подключение."
        }
      }
    },
    "kresus": {
      "qr_code": {
        "step1": {
          "title": "Откройте приложение Kresus Wallet",
          "description": "Добавьте кошелек Kresus на экран быстрого доступа для ускоренного доступа к вашему кошельку."
        },
        "step2": {
          "title": "Создать или Импортировать кошелек",
          "description": "Создайте новый кошелек или импортируйте существующий."
        },
        "step3": {
          "title": "Нажмите на иконку QR и отсканируйте",
          "description": "Нажмите на иконку QR на главном экране, отсканируйте код и подтвердите запрос на подключение."
        }
      }
    },
    "magicEden": {
      "extension": {
        "step1": {
          "title": "Установите расширение Magic Eden",
          "description": "Мы рекомендуем закрепить Magic Eden на вашей панели задач для более удобного доступа к вашему кошельку."
        },
        "step2": {
          "title": "Создать или Импортировать кошелек",
          "description": "Обязательно сделайте резервную копию вашего кошелька с помощью безопасного метода. Никогда не делитесь своей секретной фразой восстановления с кем-либо."
        },
        "step3": {
          "title": "Обновите ваш браузер",
          "description": "После настройки вашего кошелька, нажмите ниже, чтобы обновить браузер и загрузить расширение."
        }
      }
    },
    "metamask": {
      "qr_code": {
        "step1": {
          "title": "Откройте приложение MetaMask",
          "description": "Мы рекомендуем поместить MetaMask на главный экран для быстрого доступа."
        },
        "step2": {
          "title": "Создайте или импортируйте кошелек",
          "description": "Обязательно сохраните копию своего кошелька с помощью надежного метода. Никогда не делитесь своей секретной фразой с кем бы то ни было."
        },
        "step3": {
          "title": "Нажмите кнопку сканирования",
          "description": "После сканирования появится запрос на соединение вашего кошелька."
        }
      },
      "extension": {
        "step1": {
          "title": "Установите расширение MetaMask",
          "description": "Мы рекомендуем закрепить MetaMask на вашей панели задач для более быстрого доступа к вашему кошельку."
        },
        "step2": {
          "title": "Создать или импортировать кошелек",
          "description": "Обязательно сохраните резервную копию вашего кошелька с помощью безопасного метода. Никогда не делитесь своей секретной фразой с кем-либо."
        },
        "step3": {
          "title": "Обновите ваш браузер",
          "description": "После настройки вашего кошелька, щелкните ниже, чтобы обновить браузер и загрузить расширение."
        }
      }
    },
    "nestwallet": {
      "extension": {
        "step1": {
          "title": "Установите расширение NestWallet",
          "description": "Мы рекомендуем закрепить NestWallet на панели задач для более быстрого доступа к вашему кошельку."
        },
        "step2": {
          "title": "Создать или Импортировать кошелек",
          "description": "Обязательно сделайте резервную копию вашего кошелька с использованием безопасного метода. Никогда не делитесь своей секретной фразой с кем-либо."
        },
        "step3": {
          "title": "Обновите ваш браузер",
          "description": "После настройки вашего кошелька, нажмите ниже, чтобы обновить браузер и загрузить расширение."
        }
      }
    },
    "okx": {
      "qr_code": {
        "step1": {
          "title": "Откройте приложение кошелька OKX",
          "description": "Мы рекомендуем разместить кошелек OKX на вашем главном экране для более быстрого доступа."
        },
        "step2": {
          "title": "Создать или импортировать кошелек",
          "description": "Обязательно сохраните резервную копию вашего кошелька с помощью безопасного метода. Никогда не делитесь своей секретной фразой с кем-либо."
        },
        "step3": {
          "title": "Нажмите на кнопку сканирования",
          "description": "После сканирования появится запрос на подключение вашего кошелька."
        }
      },
      "extension": {
        "step1": {
          "title": "Установите расширение кошелька OKX",
          "description": "Мы рекомендуем закрепить OKX Wallet на панели задач для более быстрого доступа к вашему кошельку."
        },
        "step2": {
          "title": "Создать кошелек или импортировать кошелек",
          "description": "Обязательно сохраните резервную копию вашего кошелька с помощью безопасного метода. Никогда не делитесь своей секретной фразой с кем-либо."
        },
        "step3": {
          "title": "Обновите ваш браузер",
          "description": "Как только вы настроите свой кошелек, нажмите ниже, чтобы обновить браузер и загрузить расширение."
        }
      }
    },
    "omni": {
      "qr_code": {
        "step1": {
          "title": "Откройте приложение Omni",
          "description": "Добавьте Omni на свой домашний экран для более быстрого доступа к вашему кошельку."
        },
        "step2": {
          "title": "Создать или импортировать кошелек",
          "description": "Создайте новый кошелек или импортируйте существующий."
        },
        "step3": {
          "title": "Нажмите на иконку QR и отсканируйте",
          "description": "Нажмите на иконку QR на вашем домашнем экране, отсканируйте код и подтвердите подсказку, чтобы подключиться."
        }
      }
    },
    "1inch": {
      "qr_code": {
        "step1": {
          "description": "Добавьте 1inch Wallet на главный экран для более быстрого доступа к вашему кошельку.",
          "title": "Откройте приложение 1inch Wallet"
        },
        "step2": {
          "description": "Создайте кошелек и имя пользователя или импортируйте существующий кошелек.",
          "title": "Создать или Импортировать кошелек"
        },
        "step3": {
          "description": "После сканирования появится запрос на подключение для подключения вашего кошелька.",
          "title": "Нажмите кнопку Сканировать QR"
        }
      }
    },
    "token_pocket": {
      "qr_code": {
        "step1": {
          "title": "Откройте приложение TokenPocket",
          "description": "Мы рекомендуем разместить TokenPocket на вашем домашнем экране для быстрого доступа."
        },
        "step2": {
          "title": "Создать или Импортировать кошелек",
          "description": "Обязательно сделайте резервную копию вашего кошелька при помощи безопасного метода. Никогда не делитесь своим секретным кодом с кем-либо."
        },
        "step3": {
          "title": "Нажмите на кнопку сканирования",
          "description": "После сканирования появится подсказка о подключении для подключения вашего кошелька."
        }
      },
      "extension": {
        "step1": {
          "title": "Установите расширение TokenPocket",
          "description": "Мы рекомендуем закрепить TokenPocket на вашей панели задач для более быстрого доступа к вашему кошельку."
        },
        "step2": {
          "title": "Создать или Импортировать кошелек",
          "description": "Обязательно создайте резервную копию вашего кошелька с помощью безопасного метода. Никогда не делитесь своей секретной фразой с кем-либо."
        },
        "step3": {
          "title": "Обновите ваш браузер",
          "description": "После того как вы настроите свой кошелек, нажмите ниже, чтобы обновить браузер и загрузить расширение."
        }
      }
    },
    "trust": {
      "qr_code": {
        "step1": {
          "title": "Откройте приложение Trust Wallet",
          "description": "Разместите Trust Wallet на вашем домашнем экране для более быстрого доступа к вашему кошельку."
        },
        "step2": {
          "title": "Создать или Импортировать кошелек",
          "description": "Создайте новый кошелек или импортируйте существующий."
        },
        "step3": {
          "title": "Нажмите WalletConnect в настройках",
          "description": "Выберите Новое соединение, затем сканируйте QR-код и подтвердите запрос на подключение."
        }
      },
      "extension": {
        "step1": {
          "title": "Установите расширение Trust Wallet",
          "description": "Кликните в правом верхнем углу вашего браузера и закрепите Trust Wallet для легкого доступа."
        },
        "step2": {
          "title": "Создайте или импортируйте кошелек",
          "description": "Создайте новый кошелек или импортируйте существующий."
        },
        "step3": {
          "title": "Обновите ваш браузер",
          "description": "После настройки Trust Wallet, нажмите ниже, чтобы обновить браузер и загрузить расширение."
        }
      }
    },
    "uniswap": {
      "qr_code": {
        "step1": {
          "title": "Откройте приложение Uniswap",
          "description": "Добавьте кошелек Uniswap на главный экран для быстрого доступа к вашему кошельку."
        },
        "step2": {
          "title": "Создать или импортировать кошелек",
          "description": "Создайте новый кошелек или импортируйте существующий."
        },
        "step3": {
          "title": "Нажмите на иконку QR и отсканируйте",
          "description": "Нажмите на иконку QR на главном экране, отсканируйте код и подтвердите запрос на подключение."
        }
      }
    },
    "zerion": {
      "qr_code": {
        "step1": {
          "title": "Откройте приложение Zerion",
          "description": "Мы рекомендуем разместить Zerion на главном экране для более быстрого доступа."
        },
        "step2": {
          "title": "Создать или импортировать кошелек",
          "description": "Обязательно создайте резервную копию вашего кошелька с помощью безопасного метода. Никогда не делитесь своей секретной фразой с кем-либо."
        },
        "step3": {
          "title": "Нажмите кнопку сканирования",
          "description": "После сканирования вам будет предложено подключить ваш кошелек."
        }
      },
      "extension": {
        "step1": {
          "title": "Установите расширение Zerion",
          "description": "Мы рекомендуем прикрепить Zerion к вашей панели задач для более быстрого доступа к вашему кошельку."
        },
        "step2": {
          "title": "Создайте или импортируйте кошелек",
          "description": "Обязательно сделайте резервную копию вашего кошелька с помощью безопасного метода. Никогда не делясь своим секретным паролем с кем-либо."
        },
        "step3": {
          "title": "Обновите ваш браузер",
          "description": "Как только вы настроите свой кошелек, нажмите ниже, чтобы обновить браузер и загрузить расширение."
        }
      }
    },
    "rainbow": {
      "qr_code": {
        "step1": {
          "title": "Откройте приложение Rainbow",
          "description": "Мы рекомендуем поместить Rainbow на ваш экран главного меню для более быстрого доступа к вашему кошельку."
        },
        "step2": {
          "title": "Создайте или импортируйте кошелек",
          "description": "Вы можете легко сделать резервную копию вашего кошелька с помощью нашей функции резервного копирования на вашем телефоне."
        },
        "step3": {
          "title": "Нажмите кнопку сканировать",
          "description": "После сканирования появится запрос на подключение вашего кошелька."
        }
      }
    },
    "enkrypt": {
      "extension": {
        "step1": {
          "description": "Мы рекомендуем закрепить Enkrypt Wallet на панели задач для более быстрого доступа к вашему кошельку.",
          "title": "Установите расширение Enkrypt Wallet"
        },
        "step2": {
          "description": "Обязательно сделайте резервную копию вашего кошелька с использованием безопасного метода. Никогда не делитесь своей секретной фразой с кем-либо.",
          "title": "Создать или импортировать кошелек"
        },
        "step3": {
          "description": "Как только вы настроите свой кошелек, нажмите ниже, чтобы обновить браузер и загрузить расширение.",
          "title": "Обновите ваш браузер"
        }
      }
    },
    "frame": {
      "extension": {
        "step1": {
          "description": "Мы рекомендуем закрепить Frame на панели задач для более быстрого доступа к вашему кошельку.",
          "title": "Установите Frame и дополнительное расширение"
        },
        "step2": {
          "description": "Обязательно создайте резервную копию вашего кошелька с помощью безопасного метода. Никогда не делитесь своей секретной фразой с кем-либо.",
          "title": "Создайте или Импортируйте кошелек"
        },
        "step3": {
          "description": "После того как вы настроите свой кошелек, нажмите ниже, чтобы обновить браузер и загрузить расширение.",
          "title": "Обновите ваш браузер"
        }
      }
    },
    "one_key": {
      "extension": {
        "step1": {
          "title": "Установите расширение OneKey Wallet",
          "description": "Мы рекомендуем закрепить OneKey Wallet на панели задач для более быстрого доступа к вашему кошельку."
        },
        "step2": {
          "title": "Создайте или Импортируйте кошелек",
          "description": "Обязательно сделайте резервную копию вашего кошелька с помощью безопасного метода. Никогда не делитесь своей секретной фразой с кем-либо."
        },
        "step3": {
          "title": "Обновите ваш браузер",
          "description": "После настройки кошелька нажмите ниже, чтобы обновить браузер и загрузить расширение."
        }
      }
    },
    "paraswap": {
      "qr_code": {
        "step1": {
          "title": "Откройте приложение ParaSwap",
          "description": "Добавьте кошелек ParaSwap на главный экран для быстрого доступа к вашему кошельку."
        },
        "step2": {
          "title": "Создать или Импортировать кошелек",
          "description": "Создайте новый кошелек или импортируйте существующий."
        },
        "step3": {
          "title": "Нажмите на иконку QR и отсканируйте",
          "description": "Нажмите на иконку QR на главном экране, отсканируйте код и подтвердите запрос на подключение."
        }
      }
    },
    "phantom": {
      "extension": {
        "step1": {
          "title": "Установите расширение Phantom",
          "description": "Мы рекомендуем закрепить Phantom на панели задач для более удобного доступа к вашему кошельку."
        },
        "step2": {
          "title": "Создать или Импортировать кошелек",
          "description": "Обязательно сделайте резервную копию вашего кошелька с помощью безопасного метода. Никогда не делитесь своей секретной фразой восстановления с кем-либо."
        },
        "step3": {
          "title": "Обновите ваш браузер",
          "description": "После того как вы настроите свой кошелек, нажмите ниже, чтобы обновить браузер и загрузить расширение."
        }
      }
    },
    "rabby": {
      "extension": {
        "step1": {
          "title": "Установите расширение Rabby",
          "description": "Мы рекомендуем закрепить Rabby на панели задач для более быстрого доступа к вашему кошельку."
        },
        "step2": {
          "title": "Создать или импортировать кошелек",
          "description": "Обязательно сделайте резервную копию вашего кошелька с помощью безопасного метода. Никогда не делитесь своей секретной фразой с кем бы то ни было."
        },
        "step3": {
          "title": "Обновите ваш браузер",
          "description": "После настройки вашего кошелька, нажмите ниже, чтобы обновить браузер и загрузить расширение."
        }
      }
    },
    "ronin": {
      "qr_code": {
        "step1": {
          "description": "Мы рекомендуем добавить кошелек Ronin на ваш экран быстрого доступа для более быстрого доступа.",
          "title": "Откройте приложение кошелька Ronin"
        },
        "step2": {
          "description": "Обязательно сделайте резервную копию вашего кошелька с использованием безопасного метода. Никогда не делитесь своей секретной фразой с кем-либо.",
          "title": "Создать или Импортировать кошелек"
        },
        "step3": {
          "description": "После сканирования появится запрос на подключение для подключения вашего кошелька.",
          "title": "Нажмите кнопку сканирования"
        }
      },
      "extension": {
        "step1": {
          "description": "Мы рекомендуем закрепить кошелек Ronin на панели задач для более быстрого доступа к вашему кошельку.",
          "title": "Установите расширение кошелька Ronin"
        },
        "step2": {
          "description": "Обязательно сделайте резервную копию вашего кошелька с использованием безопасного метода. Никогда не делитесь своей секретной фразой с кем-либо.",
          "title": "Создать или Импортировать кошелек"
        },
        "step3": {
          "description": "После настройки вашего кошелька, нажмите ниже, чтобы обновить браузер и загрузить расширение.",
          "title": "Обновите ваш браузер"
        }
      }
    },
    "ramper": {
      "extension": {
        "step1": {
          "title": "Установите расширение Ramper",
          "description": "Мы рекомендуем закрепить Ramper на панели задач для удобного доступа к вашему кошельку."
        },
        "step2": {
          "title": "Создать кошелек",
          "description": "Обязательно сделайте резервную копию вашего кошелька с использованием безопасного метода. Никогда не делитесь своей секретной фразой с кем-либо."
        },
        "step3": {
          "title": "Обновите ваш браузер",
          "description": "После настройки вашего кошелька, нажмите ниже, чтобы обновить браузер и загрузить расширение."
        }
      }
    },
    "safeheron": {
      "extension": {
        "step1": {
          "title": "Установите основное расширение",
          "description": "Мы рекомендуем закрепить SafeHeron на панели задач для более быстрого доступа к вашему кошельку."
        },
        "step2": {
          "title": "Создать или импортировать кошелек",
          "description": "Обязательно сделайте резервную копию вашего кошелька с использованием безопасного метода. Никогда не делитесь своей секретной фразой с кем-либо."
        },
        "step3": {
          "title": "Обновите ваш браузер",
          "description": "После того, как вы настроите ваш кошелек, нажмите ниже, чтобы обновить браузер и загрузить расширение."
        }
      }
    },
    "taho": {
      "extension": {
        "step1": {
          "title": "Установите расширение Taho",
          "description": "Мы рекомендуем закрепить Taho на вашей панели задач для более быстрого доступа к вашему кошельку."
        },
        "step2": {
          "title": "Создать или импортировать кошелек",
          "description": "Обязательно сделайте резервную копию вашего кошелька с использованием безопасного метода. Никогда не делитесь своей секретной фразой с кем-либо."
        },
        "step3": {
          "title": "Обновите ваш браузер",
          "description": "После настройки вашего кошелька, нажмите ниже, чтобы обновить браузер и загрузить расширение."
        }
      }
    },
    "wigwam": {
      "extension": {
        "step1": {
          "title": "Установите расширение Wigwam",
          "description": "Мы рекомендуем закрепить Wigwam на панели задач для быстрого доступа к вашему кошельку."
        },
        "step2": {
          "title": "Создать или Импортировать кошелек",
          "description": "Обязательно сделайте резервную копию вашего кошелька с использованием безопасного метода. Никогда не делитесь своей секретной фразой с кем-либо."
        },
        "step3": {
          "title": "Обновите ваш браузер",
          "description": "После настройки вашего кошелька, нажмите ниже, чтобы обновить браузер и загрузить расширение."
        }
      }
    },
    "talisman": {
      "extension": {
        "step1": {
          "title": "Установите расширение Talisman",
          "description": "Мы рекомендуем закрепить Talisman на вашей панели задач для более быстрого доступа к вашему кошельку."
        },
        "step2": {
          "title": "Создайте или импортируйте кошелек Ethereum",
          "description": "Обязательно сделайте резервную копию вашего кошелька с помощью безопасного метода. Никогда не делитесь вашей фразой восстановления с кем-либо."
        },
        "step3": {
          "title": "Обновите ваш браузер",
          "description": "После настройки вашего кошелька, нажмите ниже, чтобы обновить браузер и загрузить расширение."
        }
      }
    },
    "xdefi": {
      "extension": {
        "step1": {
          "title": "Установите расширение кошелька XDEFI",
          "description": "Мы рекомендуем закрепить XDEFI Wallet на панели задач для более быстрого доступа к вашему кошельку."
        },
        "step2": {
          "title": "Создать или Импортировать кошелек",
          "description": "Обязательно создайте резервную копию вашего кошелька с помощью безопасного метода. Никогда не делитесь своей секретной фразой с кем-либо."
        },
        "step3": {
          "title": "Обновите ваш браузер",
          "description": "После того, как вы настроите свой кошелек, нажмите ниже, чтобы обновить браузер и загрузить расширение."
        }
      }
    },
    "zeal": {
      "qr_code": {
        "step1": {
          "title": "Откройте приложение Zeal",
          "description": "Добавьте Zeal Wallet на домашний экран для более быстрого доступа к вашему кошельку."
        },
        "step2": {
          "title": "Создать или Импортировать кошелек",
          "description": "Создайте новый кошелек или импортируйте существующий."
        },
        "step3": {
          "title": "Нажмите на иконку QR и отсканируйте",
          "description": "Нажмите на иконку QR на главном экране, отсканируйте код и подтвердите запрос на подключение."
        }
      },
      "extension": {
        "step1": {
          "title": "Установите расширение Zeal",
          "description": "Мы рекомендуем закрепить Zeal на панели задач для быстрого доступа к вашему кошельку."
        },
        "step2": {
          "title": "Создать или Импортировать кошелек",
          "description": "Обязательно сделайте резервную копию вашего кошелька с использованием безопасного метода. Никогда не делитесь своей секретной фразой с кем-либо."
        },
        "step3": {
          "title": "Обновите ваш браузер",
          "description": "После настройки вашего кошелька, нажмите ниже, чтобы обновить браузер и загрузить расширение."
        }
      }
    },
    "safepal": {
      "extension": {
        "step1": {
          "title": "Установите расширение SafePal Wallet",
          "description": "Кликните в верхнем правом углу вашего браузера и закрепите SafePal Wallet для удобного доступа."
        },
        "step2": {
          "title": "Создайте или импортируйте кошелек",
          "description": "Создайте новый кошелек или импортируйте существующий."
        },
        "step3": {
          "title": "Обновите ваш браузер",
          "description": "После настройки кошелька SafePal нажмите ниже, чтобы обновить браузер и загрузить расширение."
        }
      },
      "qr_code": {
        "step1": {
          "title": "Откройте приложение SafePal Wallet",
          "description": "Разместите SafePal Wallet на главном экране для более быстрого доступа к вашему кошельку."
        },
        "step2": {
          "title": "Создать или Импортировать кошелек",
          "description": "Создайте новый кошелек или импортируйте существующий."
        },
        "step3": {
          "title": "Нажмите WalletConnect в настройках",
          "description": "Выберите Новое соединение, затем отсканируйте QR-код и подтвердите запрос на соединение."
        }
      }
    },
    "desig": {
      "extension": {
        "step1": {
          "title": "Установите расширение Desig",
          "description": "Мы рекомендуем закрепить Desig на вашей панели задач для более удобного доступа к вашему кошельку."
        },
        "step2": {
          "title": "Создать кошелек",
          "description": "Обязательно сделайте резервную копию вашего кошелька с использованием безопасного метода. Никогда не делитесь своей секретной фразой с кем-либо."
        },
        "step3": {
          "title": "Обновите ваш браузер",
          "description": "После настройки вашего кошелька, нажмите ниже, чтобы обновить браузер и загрузить расширение."
        }
      }
    },
    "subwallet": {
      "extension": {
        "step1": {
          "title": "Установите расширение SubWallet",
          "description": "Мы рекомендуем закрепить SubWallet на вашей панели задач для более быстрого доступа к вашему кошельку."
        },
        "step2": {
          "title": "Создать или Импортировать кошелек",
          "description": "Обязательно сделайте резервную копию вашего кошелька с помощью безопасного метода. Никогда не делитесь вашей фразой восстановления с кем-либо."
        },
        "step3": {
          "title": "Обновите ваш браузер",
          "description": "После настройки вашего кошелька, нажмите ниже, чтобы обновить браузер и загрузить расширение."
        }
      },
      "qr_code": {
        "step1": {
          "title": "Откройте приложение SubWallet",
          "description": "Мы рекомендуем добавить SubWallet на ваш экран начальной страницы для более быстрого доступа."
        },
        "step2": {
          "title": "Создать или Импортировать кошелек",
          "description": "Обязательно сделайте резервную копию вашего кошелька с использованием безопасного метода. Никогда не делитесь своей секретной фразой с кем-либо."
        },
        "step3": {
          "title": "Нажмите кнопку сканирования",
          "description": "После сканирования появится запрос на подключение для подключения вашего кошелька."
        }
      }
    },
    "clv": {
      "extension": {
        "step1": {
          "title": "Установите расширение CLV Wallet",
          "description": "Мы рекомендуем закрепить CLV Wallet на вашей панели задач для более быстрого доступа к вашему кошельку."
        },
        "step2": {
          "title": "Создать или Импортировать кошелек",
          "description": "Обязательно сделайте резервную копию вашего кошелька с использованием безопасного метода. Никогда не делитесь своей секретной фразой с кем-либо."
        },
        "step3": {
          "title": "Обновите ваш браузер",
          "description": "После настройки вашего кошелька, нажмите ниже, чтобы обновить браузер и загрузить расширение."
        }
      },
      "qr_code": {
        "step1": {
          "title": "Откройте приложение CLV Wallet",
          "description": "Мы рекомендуем поместить CLV Wallet на ваш экран домой для более быстрого доступа."
        },
        "step2": {
          "title": "Создать или Импортировать кошелек",
          "description": "Обязательно сделайте резервную копию вашего кошелька с использованием безопасного метода. Никогда не делитесь своей секретной фразой с кем-либо."
        },
        "step3": {
          "title": "Нажмите кнопку сканирования",
          "description": "После сканирования появится запрос на подключение для подключения вашего кошелька."
        }
      }
    },
    "okto": {
      "qr_code": {
        "step1": {
          "title": "Откройте приложение Okto",
          "description": "Добавьте Okto на ваш экран домой для быстрого доступа"
        },
        "step2": {
          "title": "Создать кошелек MPC",
          "description": "Создайте учетную запись и сгенерируйте кошелек"
        },
        "step3": {
          "title": "Нажмите WalletConnect в настройках",
          "description": "Коснитесь значка Scan QR в верхнем правом углу и подтвердите запрос на подключение."
        }
      }
    },
    "ledger": {
      "desktop": {
        "step1": {
          "title": "Откройте приложение Ledger Live",
          "description": "Мы рекомендуем поместить Ledger Live на ваш экран домой для более быстрого доступа."
        },
        "step2": {
          "title": "Настройте ваш Ledger",
          "description": "Настройте новый Ledger или подключитесь к существующему."
        },
        "step3": {
          "title": "Подключить",
          "description": "После сканирования вам будет предложено подключить ваш кошелек."
        }
      },
      "qr_code": {
        "step1": {
          "title": "Откройте приложение Ledger Live",
          "description": "Мы рекомендуем поместить Ledger Live на ваш экран домой для более быстрого доступа."
        },
        "step2": {
          "title": "Настройте ваш Ledger",
          "description": "Вы можете синхронизировать с настольным приложением или подключить свой Ledger."
        },
        "step3": {
          "title": "Сканировать код",
          "description": "Нажмите WalletConnect, затем переключитесь на Scanner. После сканирования вам будет предложено подключить ваш кошелек."
        }
      }
    },
    "valora": {
      "qr_code": {
        "step1": {
          "title": "Откройте приложение Valora",
          "description": "Мы рекомендуем разместить Valora на главном экране для более быстрого доступа."
        },
        "step2": {
          "title": "Создать или импортировать кошелек",
          "description": "Создайте новый кошелек или импортируйте существующий."
        },
        "step3": {
          "title": "Нажмите кнопку сканирования",
          "description": "После сканирования появится запрос на подключение для подключения вашего кошелька."
        }
      }
    }
  }
}
`;export{u as default};
