var a=`{
  "connect_wallet": {
    "label": "Conectar Carteira",
    "wrong_network": {
      "label": "Rede incorreta"
    }
  },
  "intro": {
    "title": "O que é uma Carteira?",
    "description": "Uma carteira é usada para enviar, receber, armazenar e exibir ativos digitais. Também é uma nova forma de se conectar, sem precisar criar novas contas e senhas em todo site.",
    "digital_asset": {
      "title": "Um lar para seus ativos digitais",
      "description": "Carteiras são usadas para enviar, receber, armazenar e exibir ativos digitais como Ethereum e NFTs."
    },
    "login": {
      "title": "Uma nova maneira de fazer login",
      "description": "Em vez de criar novas contas e senhas em todos os sites, basta conectar sua carteira."
    },
    "get": {
      "label": "Obter uma Carteira"
    },
    "learn_more": {
      "label": "Saiba mais"
    }
  },
  "sign_in": {
    "label": "Verifique sua conta",
    "description": "Para concluir a conexão, você deve assinar uma mensagem em sua carteira para confirmar que você é o proprietário desta conta.",
    "message": {
      "send": "Enviar mensagem",
      "preparing": "Preparando mensagem...",
      "cancel": "Cancelar",
      "preparing_error": "Erro ao preparar a mensagem, tente novamente!"
    },
    "signature": {
      "waiting": "Aguardando assinatura...",
      "verifying": "Verificando assinatura...",
      "signing_error": "Erro ao assinar a mensagem, tente novamente!",
      "verifying_error": "Erro ao verificar assinatura, tente novamente!",
      "oops_error": "Ops, algo deu errado!"
    }
  },
  "connect": {
    "label": "Conectar",
    "title": "Conectar uma Carteira",
    "new_to_ethereum": {
      "description": "Novo nas carteiras Ethereum?",
      "learn_more": {
        "label": "Saiba mais"
      }
    },
    "learn_more": {
      "label": "Saiba mais"
    },
    "recent": "Recente",
    "status": {
      "opening": "Abrindo %{wallet}...",
      "connecting": "Conectando",
      "connect_mobile": "Continue em %{wallet}",
      "not_installed": "%{wallet} não está instalado",
      "not_available": "%{wallet} não está disponível",
      "confirm": "Confirme a conexão na extensão",
      "confirm_mobile": "Aceite o pedido de conexão na carteira"
    },
    "secondary_action": {
      "get": {
        "description": "Não tem %{wallet}?",
        "label": "OBTER"
      },
      "install": {
        "label": "INSTALAR"
      },
      "retry": {
        "label": "TENTAR DE NOVO"
      }
    },
    "walletconnect": {
      "description": {
        "full": "Precisa do modal oficial do WalletConnect?",
        "compact": "Precisa do modal WalletConnect?"
      },
      "open": {
        "label": "ABRIR"
      }
    }
  },
  "connect_scan": {
    "title": "Digitalize com %{wallet}",
    "fallback_title": "Digitalize com o seu telefone"
  },
  "connector_group": {
    "installed": "Instalado",
    "recommended": "Recomendado",
    "other": "Outro",
    "popular": "Popular",
    "more": "Mais",
    "others": "Outros"
  },
  "get": {
    "title": "Obter uma Carteira",
    "action": {
      "label": "OBTER"
    },
    "mobile": {
      "description": "Carteira Móvel"
    },
    "extension": {
      "description": "Extensão do Navegador"
    },
    "mobile_and_extension": {
      "description": "Carteira Móvel e Extensão"
    },
    "mobile_and_desktop": {
      "description": "Carteira para Mobile e Desktop"
    },
    "looking_for": {
      "title": "Não é o que você está procurando?",
      "mobile": {
        "description": "Selecione uma carteira na tela principal para começar com um provedor de carteira diferente."
      },
      "desktop": {
        "compact_description": "Selecione uma carteira na tela principal para começar com um provedor de carteira diferente.",
        "wide_description": "Selecione uma carteira à esquerda para começar com um provedor de carteira diferente."
      }
    }
  },
  "get_options": {
    "title": "Comece com %{wallet}",
    "short_title": "Obtenha %{wallet}",
    "mobile": {
      "title": "%{wallet} para Móvel",
      "description": "Use a carteira móvel para explorar o mundo do Ethereum.",
      "download": {
        "label": "Baixe o aplicativo"
      }
    },
    "extension": {
      "title": "%{wallet} para %{browser}",
      "description": "Acesse sua carteira diretamente do seu navegador web favorito.",
      "download": {
        "label": "Adicionar ao %{browser}"
      }
    },
    "desktop": {
      "title": "%{wallet} para %{platform}",
      "description": "Acesse sua carteira nativamente do seu desktop poderoso.",
      "download": {
        "label": "Adicionar ao %{platform}"
      }
    }
  },
  "get_mobile": {
    "title": "Instale %{wallet}",
    "description": "Escaneie com seu celular para baixar no iOS ou Android",
    "continue": {
      "label": "Continuar"
    }
  },
  "get_instructions": {
    "mobile": {
      "connect": {
        "label": "Conectar"
      },
      "learn_more": {
        "label": "Saiba mais"
      }
    },
    "extension": {
      "refresh": {
        "label": "Atualizar"
      },
      "learn_more": {
        "label": "Saiba mais"
      }
    },
    "desktop": {
      "connect": {
        "label": "Conectar"
      },
      "learn_more": {
        "label": "Saiba mais"
      }
    }
  },
  "chains": {
    "title": "Mudar Redes",
    "wrong_network": "Rede errada detectada, mude ou desconecte para continuar.",
    "confirm": "Confirme na Carteira",
    "switching_not_supported": "Sua carteira não suporta a mudança de redes de %{appName}. Tente mudar de redes dentro da sua carteira.",
    "switching_not_supported_fallback": "Sua carteira não suporta a troca de redes a partir deste aplicativo. Tente trocar de rede dentro de sua carteira.",
    "disconnect": "Desconectar",
    "connected": "Conectado"
  },
  "profile": {
    "disconnect": {
      "label": "Desconectar"
    },
    "copy_address": {
      "label": "Copiar Endereço",
      "copied": "Copiado!"
    },
    "explorer": {
      "label": "Veja mais no explorador"
    },
    "transactions": {
      "description": "%{appName} transações aparecerão aqui...",
      "description_fallback": "Suas transações aparecerão aqui...",
      "recent": {
        "title": "Transações Recentes"
      },
      "clear": {
        "label": "Limpar Tudo"
      }
    }
  },
  "wallet_connectors": {
    "argent": {
      "qr_code": {
        "step1": {
          "description": "Coloque o Argent na tela inicial para um acesso mais rápido à sua carteira.",
          "title": "Abra o aplicativo Argent"
        },
        "step2": {
          "description": "Crie uma carteira e nome de usuário, ou importe uma carteira existente.",
          "title": "Criar ou Importar uma Carteira"
        },
        "step3": {
          "description": "Depois que você escanear, um prompt de conexão aparecerá para você conectar sua carteira.",
          "title": "Toque no botão Scan QR"
        }
      }
    },
    "berasig": {
      "extension": {
        "step1": {
          "title": "Instale a extensão BeraSig",
          "description": "Recomendamos fixar BeraSig na sua barra de tarefas para facilitar o acesso à sua carteira."
        },
        "step2": {
          "title": "Criar uma Carteira",
          "description": "Certifique-se de fazer backup de sua carteira usando um método seguro. Nunca compartilhe sua frase secreta com ninguém."
        },
        "step3": {
          "title": "Atualize seu navegador",
          "description": "Depois de configurar sua carteira, clique abaixo para atualizar o navegador e carregar a extensão."
        }
      }
    },
    "best": {
      "qr_code": {
        "step1": {
          "title": "Abra o aplicativo Best Wallet",
          "description": "Adicione a Best Wallet à sua tela inicial para um acesso mais rápido à sua carteira."
        },
        "step2": {
          "title": "Criar ou Importar uma Carteira",
          "description": "Crie uma nova carteira ou importe uma existente."
        },
        "step3": {
          "title": "Toque no ícone do QR e escaneie",
          "description": "Toque no ícone QR na sua tela inicial, escaneie o código e confirme o prompt para conectar."
        }
      }
    },
    "bifrost": {
      "qr_code": {
        "step1": {
          "description": "Recomendamos colocar a Bifrost Wallet na sua tela inicial para um acesso mais rápido.",
          "title": "Abra o aplicativo Bifrost Wallet"
        },
        "step2": {
          "description": "Crie ou importe uma carteira usando sua frase de recuperação.",
          "title": "Criar ou Importar uma Carteira"
        },
        "step3": {
          "description": "Após você escanear, um prompt de conexão aparecerá para você conectar sua carteira.",
          "title": "Toque no botão de escanear"
        }
      }
    },
    "bitget": {
      "qr_code": {
        "step1": {
          "description": "Recomendamos colocar a Bitget Wallet na sua tela inicial para um acesso mais rápido.",
          "title": "Abra o aplicativo Bitget Wallet"
        },
        "step2": {
          "description": "Certifique-se de fazer backup de sua carteira usando um método seguro. Nunca compartilhe sua frase secreta com ninguém.",
          "title": "Criar ou Importar uma Carteira"
        },
        "step3": {
          "description": "Depois de escanear, um prompt de conexão aparecerá para você conectar sua carteira.",
          "title": "Toque no botão de escaneamento"
        }
      },
      "extension": {
        "step1": {
          "description": "Recomendamos fixar a Bitget Wallet na sua barra de tarefas para um acesso mais rápido à sua carteira.",
          "title": "Instale a extensão da Carteira Bitget"
        },
        "step2": {
          "description": "Certifique-se de fazer o backup da sua carteira usando um método seguro. Nunca compartilhe sua frase secreta com ninguém.",
          "title": "Criar ou Importar uma Carteira"
        },
        "step3": {
          "description": "Depois de configurar sua carteira, clique abaixo para atualizar o navegador e carregar a extensão.",
          "title": "Atualize seu navegador"
        }
      }
    },
    "bitski": {
      "extension": {
        "step1": {
          "description": "Recomendamos fixar o Bitski na sua barra de tarefas para um acesso mais rápido à sua carteira.",
          "title": "Instale a extensão Bitski"
        },
        "step2": {
          "description": "Certifique-se de fazer backup de sua carteira usando um método seguro. Nunca compartilhe sua frase secreta com ninguém.",
          "title": "Criar ou Importar uma Carteira"
        },
        "step3": {
          "description": "Depois de configurar sua carteira, clique abaixo para atualizar o navegador e carregar a extensão.",
          "title": "Atualize seu navegador"
        }
      }
    },
    "bitverse": {
      "qr_code": {
        "step1": {
          "title": "Abra o aplicativo Bitverse Wallet",
          "description": "Adicione o Bitverse Wallet à sua tela inicial para acessar sua carteira mais rapidamente."
        },
        "step2": {
          "title": "Criar ou Importar uma Carteira",
          "description": "Crie uma nova carteira ou importe uma existente."
        },
        "step3": {
          "title": "Toque no ícone do QR e escaneie",
          "description": "Toque no ícone QR na sua tela inicial, escaneie o código e confirme o prompt para conectar."
        }
      }
    },
    "bloom": {
      "desktop": {
        "step1": {
          "title": "Abra o aplicativo Bloom Wallet",
          "description": "Recomendamos colocar o Bloom Wallet na sua tela inicial para acesso mais rápido."
        },
        "step2": {
          "description": "Crie ou importe uma carteira usando sua frase de recuperação.",
          "title": "Criar ou Importar uma Carteira"
        },
        "step3": {
          "description": "Depois de ter uma carteira, clique em Conectar para se conectar via Bloom. Um prompt de conexão aparecerá no aplicativo para você confirmar a conexão.",
          "title": "Clique em Conectar"
        }
      }
    },
    "bybit": {
      "qr_code": {
        "step1": {
          "description": "Recomendamos colocar o Bybit na sua tela inicial para acessar sua carteira mais rapidamente.",
          "title": "Abra o aplicativo Bybit"
        },
        "step2": {
          "description": "Você pode facilmente fazer backup de sua carteira usando nosso recurso de backup em seu telefone.",
          "title": "Criar ou Importar uma Carteira"
        },
        "step3": {
          "description": "Depois que você escanear, um prompt de conexão aparecerá para você conectar sua carteira.",
          "title": "Toque no botão de escanear"
        }
      },
      "extension": {
        "step1": {
          "description": "Clique no canto superior direito do seu navegador e fixe a Carteira Bybit para acesso fácil.",
          "title": "Instale a extensão da Carteira Bybit"
        },
        "step2": {
          "description": "Crie uma nova carteira ou importe uma existente.",
          "title": "Criar ou Importar uma carteira"
        },
        "step3": {
          "description": "Depois de configurar a Carteira Bybit, clique abaixo para atualizar o navegador e carregar a extensão.",
          "title": "Atualize seu navegador"
        }
      }
    },
    "binance": {
      "qr_code": {
        "step1": {
          "description": "Recomendamos colocar o Binance na tela inicial para um acesso mais rápido à sua carteira.",
          "title": "Abra o aplicativo Binance"
        },
        "step2": {
          "description": "Você pode facilmente fazer backup de sua carteira usando nosso recurso de backup em seu telefone.",
          "title": "Criar ou Importar uma Carteira"
        },
        "step3": {
          "description": "Depois que você escanear, um prompt de conexão aparecerá para você conectar sua carteira.",
          "title": "Toque no botão WalletConnect"
        }
      }
    },
    "coin98": {
      "qr_code": {
        "step1": {
          "description": "Recomendamos colocar a Carteira Coin98 na tela inicial para um acesso mais rápido à sua carteira.",
          "title": "Abra o aplicativo Carteira Coin98"
        },
        "step2": {
          "description": "Você pode facilmente fazer backup de sua carteira usando nosso recurso de backup em seu telefone.",
          "title": "Criar ou Importar uma Carteira"
        },
        "step3": {
          "description": "Depois de escanear, uma solicitação de conexão aparecerá para você conectar sua carteira.",
          "title": "Toque no botão WalletConnect"
        }
      },
      "extension": {
        "step1": {
          "description": "Clique no canto superior direito do seu navegador e fixe a Carteira Coin98 para fácil acesso.",
          "title": "Instale a extensão da Carteira Coin98"
        },
        "step2": {
          "description": "Crie uma nova carteira ou importe uma existente.",
          "title": "Criar ou Importar uma carteira"
        },
        "step3": {
          "description": "Depois de configurar a Carteira Coin98, clique abaixo para atualizar o navegador e carregar a extensão.",
          "title": "Atualize seu navegador"
        }
      }
    },
    "coinbase": {
      "qr_code": {
        "step1": {
          "description": "Recomendamos colocar a Carteira Coinbase na tela inicial para um acesso mais rápido.",
          "title": "Abra o aplicativo Coinbase Wallet"
        },
        "step2": {
          "description": "Você pode fazer backup da sua carteira facilmente usando o recurso de backup na nuvem.",
          "title": "Criar ou Importar uma Carteira"
        },
        "step3": {
          "description": "Depois de escanear, um prompt de conexão aparecerá para que você conecte sua carteira.",
          "title": "Toque no botão de escanear"
        }
      },
      "extension": {
        "step1": {
          "description": "Recomendamos fixar o Coinbase Wallet na sua barra de tarefas para um acesso mais rápido à sua carteira.",
          "title": "Instale a extensão Coinbase Wallet"
        },
        "step2": {
          "description": "Certifique-se de fazer backup da sua carteira usando um método seguro. Nunca compartilhe sua frase secreta com ninguém.",
          "title": "Criar ou Importar uma Carteira"
        },
        "step3": {
          "description": "Uma vez que você configurou sua carteira, clique abaixo para atualizar o navegador e carregar a extensão.",
          "title": "Atualize seu navegador"
        }
      }
    },
    "compass": {
      "extension": {
        "step1": {
          "description": "Recomendamos fixar a Carteira Compass na sua barra de tarefas para um acesso mais rápido à sua carteira.",
          "title": "Instale a extensão Compass Wallet"
        },
        "step2": {
          "description": "Certifique-se de fazer backup de sua carteira usando um método seguro. Nunca compartilhe sua frase secreta com ninguém.",
          "title": "Criar ou Importar uma Carteira"
        },
        "step3": {
          "description": "Depois de configurar sua carteira, clique abaixo para atualizar o navegador e carregar a extensão.",
          "title": "Atualize seu navegador"
        }
      }
    },
    "core": {
      "qr_code": {
        "step1": {
          "description": "Recomendamos colocar o Core na tela inicial para um acesso mais rápido à sua carteira.",
          "title": "Abra o aplicativo Core"
        },
        "step2": {
          "description": "Você pode facilmente salvar sua carteira usando nosso recurso de backup no seu celular.",
          "title": "Criar ou Importar uma Carteira"
        },
        "step3": {
          "description": "Depois de escanear, um prompt de conexão aparecerá para você conectar sua carteira.",
          "title": "Toque no botão WalletConnect"
        }
      },
      "extension": {
        "step1": {
          "description": "Recomendamos fixar o Core na sua barra de tarefas para um acesso mais rápido à sua carteira.",
          "title": "Instale a extensão Core"
        },
        "step2": {
          "description": "Certifique-se de fazer backup da sua carteira usando um método seguro. Nunca compartilhe sua frase secreta com ninguém.",
          "title": "Criar ou Importar uma Carteira"
        },
        "step3": {
          "description": "Depois de configurar sua carteira, clique abaixo para atualizar o navegador e carregar a extensão.",
          "title": "Atualize seu navegador"
        }
      }
    },
    "fox": {
      "qr_code": {
        "step1": {
          "description": "Recomendamos colocar o FoxWallet na tela inicial para um acesso mais rápido.",
          "title": "Abra o aplicativo FoxWallet"
        },
        "step2": {
          "description": "Certifique-se de fazer backup de sua carteira usando um método seguro. Nunca compartilhe sua frase secreta com ninguém.",
          "title": "Criar ou Importar uma Carteira"
        },
        "step3": {
          "description": "Depois de escanear, uma solicitação de conexão aparecerá para você conectar sua carteira.",
          "title": "Toque no botão de escaneamento"
        }
      }
    },
    "frontier": {
      "qr_code": {
        "step1": {
          "description": "Recomendamos colocar o Frontier Wallet na tela inicial para um acesso mais rápido.",
          "title": "Abra o aplicativo Frontier Wallet"
        },
        "step2": {
          "description": "Certifique-se de fazer backup de sua carteira usando um método seguro. Nunca compartilhe sua frase secreta com ninguém.",
          "title": "Criar ou Importar uma Carteira"
        },
        "step3": {
          "description": "Depois de escanear, aparecerá um prompt de conexão para você conectar sua carteira.",
          "title": "Toque no botão de varredura"
        }
      },
      "extension": {
        "step1": {
          "description": "Recomendamos fixar a Carteira Frontier na sua barra de tarefas para um acesso mais rápido à sua carteira.",
          "title": "Instale a extensão da Carteira Frontier"
        },
        "step2": {
          "description": "Certifique-se de fazer backup da sua carteira usando um método seguro. Nunca compartilhe sua frase secreta com ninguém.",
          "title": "Criar ou Importar uma Carteira"
        },
        "step3": {
          "description": "Depois de configurar sua carteira, clique abaixo para atualizar o navegador e carregar a extensão.",
          "title": "Atualize seu navegador"
        }
      }
    },
    "im_token": {
      "qr_code": {
        "step1": {
          "title": "Abra o aplicativo imToken",
          "description": "Coloque o aplicativo imToken na tela inicial para um acesso mais rápido à sua carteira."
        },
        "step2": {
          "title": "Criar ou Importar uma Carteira",
          "description": "Crie uma nova carteira ou importe uma existente."
        },
        "step3": {
          "title": "Toque no ícone do Scanner no canto superior direito",
          "description": "Escolha Nova Conexão, em seguida, escaneie o código QR e confirme o prompt para conectar."
        }
      }
    },
    "iopay": {
      "qr_code": {
        "step1": {
          "description": "Recomendamos colocar o ioPay na tela inicial para um acesso mais rápido à sua carteira.",
          "title": "Abra o aplicativo ioPay"
        },
        "step2": {
          "description": "Você pode facilmente fazer backup de sua carteira usando nosso recurso de backup em seu telefone.",
          "title": "Criar ou Importar uma Carteira"
        },
        "step3": {
          "description": "Depois que você escanear, um prompt de conexão aparecerá para você conectar sua carteira.",
          "title": "Toque no botão WalletConnect"
        }
      }
    },
    "kaikas": {
      "extension": {
        "step1": {
          "description": "Recomendamos fixar o Kaikas na sua barra de tarefas para acesso mais rápido à sua carteira.",
          "title": "Instale a extensão Kaikas"
        },
        "step2": {
          "description": "Certifique-se de fazer backup de sua carteira usando um método seguro. Nunca compartilhe sua frase secreta com ninguém.",
          "title": "Criar ou Importar uma Carteira"
        },
        "step3": {
          "description": "Depois de configurar sua carteira, clique abaixo para atualizar o navegador e carregar a extensão.",
          "title": "Atualize seu navegador"
        }
      },
      "qr_code": {
        "step1": {
          "title": "Abra o aplicativo Kaikas",
          "description": "Coloque o aplicativo Kaikas na sua tela inicial para acessar sua carteira mais rapidamente."
        },
        "step2": {
          "title": "Criar ou Importar uma Carteira",
          "description": "Crie uma nova carteira ou importe uma existente."
        },
        "step3": {
          "title": "Toque no ícone do Scanner no canto superior direito",
          "description": "Escolha Nova Conexão, em seguida, escaneie o código QR e confirme o prompt para conectar."
        }
      }
    },
    "kaia": {
      "extension": {
        "step1": {
          "description": "Recomendamos fixar o Kaia na sua barra de tarefas para um acesso mais rápido à sua carteira.",
          "title": "Instale a extensão Kaia"
        },
        "step2": {
          "description": "Certifique-se de fazer backup de sua carteira usando um método seguro. Nunca compartilhe sua frase secreta com ninguém.",
          "title": "Criar ou Importar uma Carteira"
        },
        "step3": {
          "description": "Depois de configurar sua carteira, clique abaixo para atualizar o navegador e carregar a extensão.",
          "title": "Atualize seu navegador"
        }
      },
      "qr_code": {
        "step1": {
          "title": "Abra o aplicativo Kaia",
          "description": "Coloque o aplicativo Kaia na tela inicial para um acesso mais rápido à sua carteira."
        },
        "step2": {
          "title": "Criar ou Importar uma Carteira",
          "description": "Crie uma nova carteira ou importe uma existente."
        },
        "step3": {
          "title": "Toque no ícone do Scanner no canto superior direito",
          "description": "Escolha Nova Conexão, em seguida, escaneie o código QR e confirme o prompt para conectar."
        }
      }
    },
    "kraken": {
      "qr_code": {
        "step1": {
          "title": "Abra o aplicativo Kraken Wallet",
          "description": "Adicione o Kraken Wallet à tela inicial para um acesso mais rápido à sua carteira."
        },
        "step2": {
          "title": "Criar ou Importar uma Carteira",
          "description": "Crie uma nova carteira ou importe uma existente."
        },
        "step3": {
          "title": "Toque no ícone do QR e escaneie",
          "description": "Toque no ícone QR na sua tela inicial, escaneie o código e confirme o prompt para conectar."
        }
      }
    },
    "kresus": {
      "qr_code": {
        "step1": {
          "title": "Abra o aplicativo Kresus Wallet",
          "description": "Adicione a Carteira Kresus à sua tela inicial para um acesso mais rápido à sua carteira."
        },
        "step2": {
          "title": "Criar ou Importar uma Carteira",
          "description": "Crie uma nova carteira ou importe uma existente."
        },
        "step3": {
          "title": "Toque no ícone do QR e escaneie",
          "description": "Toque no ícone QR na sua tela inicial, escaneie o código e confirme o prompt para conectar."
        }
      }
    },
    "magicEden": {
      "extension": {
        "step1": {
          "title": "Instale a extensão Magic Eden",
          "description": "Recomendamos fixar o Magic Eden na sua barra de tarefas para facilitar o acesso à sua carteira."
        },
        "step2": {
          "title": "Criar ou Importar uma Carteira",
          "description": "Certifique-se de fazer backup de sua carteira usando um método seguro. Nunca compartilhe sua frase secreta de recuperação com ninguém."
        },
        "step3": {
          "title": "Atualize seu navegador",
          "description": "Depois de configurar sua carteira, clique abaixo para atualizar o navegador e carregar a extensão."
        }
      }
    },
    "metamask": {
      "qr_code": {
        "step1": {
          "title": "Abra o aplicativo MetaMask",
          "description": "Recomendamos colocar o MetaMask na tela inicial para um acesso mais rápido."
        },
        "step2": {
          "title": "Criar ou Importar uma Carteira",
          "description": "Certifique-se de fazer backup de sua carteira usando um método seguro. Nunca compartilhe sua frase secreta com ninguém."
        },
        "step3": {
          "title": "Toque no botão escanear",
          "description": "Depois de escanear, aparecerá um prompt de conexão para você conectar sua carteira."
        }
      },
      "extension": {
        "step1": {
          "title": "Instale a extensão MetaMask",
          "description": "Recomendamos fixar o MetaMask na barra de tarefas para um acesso mais rápido à sua carteira."
        },
        "step2": {
          "title": "Criar ou Importar uma Carteira",
          "description": "Certifique-se de fazer backup da sua carteira usando um método seguro. Nunca compartilhe sua frase secreta com ninguém."
        },
        "step3": {
          "title": "Atualize o seu navegador",
          "description": "Depois de configurar sua carteira, clique abaixo para atualizar o navegador e carregar a extensão."
        }
      }
    },
    "nestwallet": {
      "extension": {
        "step1": {
          "title": "Instale a extensão NestWallet",
          "description": "Recomendamos fixar o NestWallet na sua barra de tarefas para um acesso mais rápido à sua carteira."
        },
        "step2": {
          "title": "Criar ou Importar uma Carteira",
          "description": "Certifique-se de fazer backup de sua carteira usando um método seguro. Nunca compartilhe sua frase secreta com ninguém."
        },
        "step3": {
          "title": "Atualize seu navegador",
          "description": "Depois de configurar sua carteira, clique abaixo para atualizar o navegador e carregar a extensão."
        }
      }
    },
    "okx": {
      "qr_code": {
        "step1": {
          "title": "Abra o aplicativo da Carteira OKX",
          "description": "Recomendamos colocar a Carteira OKX na tela inicial para um acesso mais rápido."
        },
        "step2": {
          "title": "Criar ou Importar uma Carteira",
          "description": "Certifique-se de fazer o backup da sua carteira utilizando um método seguro. Nunca compartilhe sua frase secreta com ninguém."
        },
        "step3": {
          "title": "Toque no botão de digitalização",
          "description": "Depois de escanear, aparecerá um prompt de conexão para você conectar sua carteira."
        }
      },
      "extension": {
        "step1": {
          "title": "Instale a extensão OKX Wallet",
          "description": "Recomendamos fixar a OKX Wallet na sua barra de tarefas para um acesso mais rápido à sua carteira."
        },
        "step2": {
          "title": "Criar ou Importar uma Carteira",
          "description": "Certifique-se de fazer o backup da sua carteira utilizando um método seguro. Nunca compartilhe sua frase secreta com ninguém."
        },
        "step3": {
          "title": "Atualize o seu navegador",
          "description": "Uma vez que você configurou sua carteira, clique abaixo para atualizar o navegador e carregar a extensão."
        }
      }
    },
    "omni": {
      "qr_code": {
        "step1": {
          "title": "Abra o aplicativo Omni",
          "description": "Adicione o Omni à sua tela inicial para um acesso mais rápido à sua carteira."
        },
        "step2": {
          "title": "Criar ou Importar uma Carteira",
          "description": "Crie uma nova carteira ou importe uma existente."
        },
        "step3": {
          "title": "Toque no ícone do QR e escaneie",
          "description": "Toque no ícone QR na tela inicial, escaneie o código e confirme o prompt para conectar."
        }
      }
    },
    "1inch": {
      "qr_code": {
        "step1": {
          "description": "Coloque o 1inch Wallet na sua tela inicial para acessar sua carteira mais rapidamente.",
          "title": "Abra o aplicativo 1inch Wallet"
        },
        "step2": {
          "description": "Crie uma carteira e nome de usuário, ou importe uma carteira existente.",
          "title": "Criar ou Importar uma Carteira"
        },
        "step3": {
          "description": "Depois que você escanear, um prompt de conexão aparecerá para você conectar sua carteira.",
          "title": "Toque no botão Scan QR"
        }
      }
    },
    "token_pocket": {
      "qr_code": {
        "step1": {
          "title": "Abra o aplicativo TokenPocket",
          "description": "Recomendamos colocar o TokenPocket na tela inicial para um acesso mais rápido."
        },
        "step2": {
          "title": "Criar ou Importar uma Carteira",
          "description": "Certifique-se de fazer backup de sua carteira usando um método seguro. Nunca compartilhe sua frase secreta com ninguém."
        },
        "step3": {
          "title": "Toque no botão de digitalização",
          "description": "Depois de escanear, aparecerá um prompt de conexão para você conectar sua carteira."
        }
      },
      "extension": {
        "step1": {
          "title": "Instale a extensão TokenPocket",
          "description": "Recomendamos fixar o TokenPocket em sua barra de tarefas para um acesso mais rápido à sua carteira."
        },
        "step2": {
          "title": "Criar ou Importar uma Carteira",
          "description": "Certifique-se de fazer backup de sua carteira usando um método seguro. Nunca compartilhe sua frase secreta com ninguém."
        },
        "step3": {
          "title": "Atualize seu navegador",
          "description": "Uma vez que você configurou sua carteira, clique abaixo para atualizar o navegador e carregar a extensão."
        }
      }
    },
    "trust": {
      "qr_code": {
        "step1": {
          "title": "Abra o aplicativo Trust Wallet",
          "description": "Coloque o Trust Wallet na tela inicial para um acesso mais rápido à sua carteira."
        },
        "step2": {
          "title": "Criar ou Importar uma Carteira",
          "description": "Crie uma nova carteira ou importe uma existente."
        },
        "step3": {
          "title": "Toque em WalletConnect nas Configurações",
          "description": "Escolha Nova Conexão, depois escaneie o QR code e confirme o prompt para se conectar."
        }
      },
      "extension": {
        "step1": {
          "title": "Instale a extensão Trust Wallet",
          "description": "Clique no canto superior direito do seu navegador e marque Trust Wallet para fácil acesso."
        },
        "step2": {
          "title": "Crie ou Importe uma carteira",
          "description": "Crie uma nova carteira ou importe uma existente."
        },
        "step3": {
          "title": "Atualize seu navegador",
          "description": "Depois que configurar a Trust Wallet, clique abaixo para atualizar o navegador e carregar a extensão."
        }
      }
    },
    "uniswap": {
      "qr_code": {
        "step1": {
          "title": "Abra o aplicativo Uniswap",
          "description": "Adicione a Carteira Uniswap à sua tela inicial para um acesso mais rápido à sua carteira."
        },
        "step2": {
          "title": "Criar ou Importar uma Carteira",
          "description": "Crie uma nova carteira ou importe uma existente."
        },
        "step3": {
          "title": "Toque no ícone QR e escaneie",
          "description": "Toque no ícone QR na sua tela inicial, escaneie o código e confirme o prompt para conectar."
        }
      }
    },
    "zerion": {
      "qr_code": {
        "step1": {
          "title": "Abra o aplicativo Zerion",
          "description": "Recomendamos colocar o Zerion na sua tela inicial para um acesso mais rápido."
        },
        "step2": {
          "title": "Criar ou Importar uma Carteira",
          "description": "Certifique-se de fazer backup da sua carteira usando um método seguro. Nunca compartilhe sua frase secreta com ninguém."
        },
        "step3": {
          "title": "Toque no botão de digitalização",
          "description": "Depois de digitalizar, um prompt de conexão aparecerá para que você possa conectar sua carteira."
        }
      },
      "extension": {
        "step1": {
          "title": "Instale a extensão Zerion",
          "description": "Recomendamos fixar o Zerion na sua barra de tarefas para um acesso mais rápido à sua carteira."
        },
        "step2": {
          "title": "Criar ou Importar uma Carteira",
          "description": "Certifique-se de fazer backup da sua carteira usando um método seguro. Nunca compartilhe sua frase secreta com ninguém."
        },
        "step3": {
          "title": "Atualize seu navegador",
          "description": "Depois de configurar sua carteira, clique abaixo para atualizar o navegador e carregar a extensão."
        }
      }
    },
    "rainbow": {
      "qr_code": {
        "step1": {
          "title": "Abra o aplicativo Rainbow",
          "description": "Recomendamos colocar o Rainbow na tela inicial para um acesso mais rápido à sua carteira."
        },
        "step2": {
          "title": "Criar ou Importar uma Carteira",
          "description": "Você pode facilmente fazer backup da sua carteira usando nosso recurso de backup no seu telefone."
        },
        "step3": {
          "title": "Toque no botão de digitalizar",
          "description": "Depois de escanear, uma solicitação de conexão aparecerá para você conectar sua carteira."
        }
      }
    },
    "enkrypt": {
      "extension": {
        "step1": {
          "description": "Recomendamos fixar a Carteira Enkrypt na sua barra de tarefas para um acesso mais rápido à sua carteira.",
          "title": "Instale a extensão da Carteira Enkrypt"
        },
        "step2": {
          "description": "Certifique-se de fazer backup da sua carteira usando um método seguro. Nunca compartilhe sua frase secreta com ninguém.",
          "title": "Criar ou Importar uma Carteira"
        },
        "step3": {
          "description": "Depois de configurar sua carteira, clique abaixo para atualizar o navegador e carregar a extensão.",
          "title": "Atualize o seu navegador"
        }
      }
    },
    "frame": {
      "extension": {
        "step1": {
          "description": "Recomendamos fixar o Frame na sua barra de tarefas para um acesso mais rápido à sua carteira.",
          "title": "Instale o Frame e a extensão complementar"
        },
        "step2": {
          "description": "Certifique-se de fazer backup da sua carteira usando um método seguro. Nunca compartilhe sua frase secreta com ninguém.",
          "title": "Criar ou Importar uma Carteira"
        },
        "step3": {
          "description": "Depois de configurar sua carteira, clique abaixo para atualizar o navegador e carregar a extensão.",
          "title": "Atualize seu navegador"
        }
      }
    },
    "one_key": {
      "extension": {
        "step1": {
          "title": "Instale a extensão OneKey Wallet",
          "description": "Recomendamos fixar a OneKey Wallet na sua barra de tarefas para um acesso mais rápido à sua carteira."
        },
        "step2": {
          "title": "Criar ou Importar uma Carteira",
          "description": "Certifique-se de fazer backup de sua carteira usando um método seguro. Nunca compartilhe sua frase secreta com ninguém."
        },
        "step3": {
          "title": "Atualize seu navegador",
          "description": "Uma vez que você configurou sua carteira, clique abaixo para atualizar o navegador e carregar a extensão."
        }
      }
    },
    "paraswap": {
      "qr_code": {
        "step1": {
          "title": "Abra o aplicativo ParaSwap",
          "description": "Adicione a Carteira ParaSwap à sua tela inicial para um acesso mais rápido à sua carteira."
        },
        "step2": {
          "title": "Criar ou Importar uma Carteira",
          "description": "Crie uma nova carteira ou importe uma existente."
        },
        "step3": {
          "title": "Toque no ícone do QR e escaneie",
          "description": "Toque no ícone QR na sua tela inicial, escaneie o código e confirme o prompt para conectar."
        }
      }
    },
    "phantom": {
      "extension": {
        "step1": {
          "title": "Instale a extensão Phantom",
          "description": "Recomendamos fixar o Phantom na sua barra de tarefas para facilitar o acesso à sua carteira."
        },
        "step2": {
          "title": "Criar ou Importar uma Carteira",
          "description": "Certifique-se de fazer backup de sua carteira usando um método seguro. Nunca compartilhe sua frase secreta de recuperação com ninguém."
        },
        "step3": {
          "title": "Atualize seu navegador",
          "description": "Depois de configurar sua carteira, clique abaixo para atualizar o navegador e carregar a extensão."
        }
      }
    },
    "rabby": {
      "extension": {
        "step1": {
          "title": "Instale a extensão Rabby",
          "description": "Recomendamos fixar Rabby na sua barra de tarefas para um acesso mais rápido à sua carteira."
        },
        "step2": {
          "title": "Criar ou Importar uma Carteira",
          "description": "Certifique-se de fazer backup da sua carteira usando um método seguro. Nunca compartilhe sua frase secreta com ninguém."
        },
        "step3": {
          "title": "Atualize seu navegador",
          "description": "Depois de configurar sua carteira, clique abaixo para atualizar o navegador e carregar a extensão."
        }
      }
    },
    "ronin": {
      "qr_code": {
        "step1": {
          "description": "Recomendamos colocar a Carteira Ronin na tela inicial para um acesso mais rápido.",
          "title": "Abra o aplicativo Carteira Ronin"
        },
        "step2": {
          "description": "Certifique-se de fazer backup de sua carteira usando um método seguro. Nunca compartilhe sua frase secreta com ninguém.",
          "title": "Criar ou Importar uma Carteira"
        },
        "step3": {
          "description": "Depois que você escanear, um prompt de conexão aparecerá para você conectar sua carteira.",
          "title": "Toque no botão de escanear"
        }
      },
      "extension": {
        "step1": {
          "description": "Recomendamos fixar a Carteira Ronin na sua barra de tarefas para um acesso mais rápido à sua carteira.",
          "title": "Instale a extensão da Carteira Ronin"
        },
        "step2": {
          "description": "Certifique-se de fazer backup de sua carteira usando um método seguro. Nunca compartilhe sua frase secreta com ninguém.",
          "title": "Criar ou Importar uma Carteira"
        },
        "step3": {
          "description": "Depois de configurar sua carteira, clique abaixo para atualizar o navegador e carregar a extensão.",
          "title": "Atualize seu navegador"
        }
      }
    },
    "ramper": {
      "extension": {
        "step1": {
          "title": "Instale a extensão Ramper",
          "description": "Recomendamos fixar o Ramper na sua barra de tarefas para um acesso mais fácil à sua carteira."
        },
        "step2": {
          "title": "Criar uma Carteira",
          "description": "Certifique-se de fazer backup de sua carteira usando um método seguro. Nunca compartilhe sua frase secreta com ninguém."
        },
        "step3": {
          "title": "Atualize seu navegador",
          "description": "Depois de configurar sua carteira, clique abaixo para atualizar o navegador e carregar a extensão."
        }
      }
    },
    "safeheron": {
      "extension": {
        "step1": {
          "title": "Instale a extensão Core",
          "description": "Recomendamos fixar Safeheron na sua barra de tarefas para um acesso mais rápido à sua carteira."
        },
        "step2": {
          "title": "Criar ou Importar uma Carteira",
          "description": "Certifique-se de fazer o backup da sua carteira usando um método seguro. Nunca compartilhe sua frase secreta com ninguém."
        },
        "step3": {
          "title": "Atualize seu navegador",
          "description": "Depois de configurar sua carteira, clique abaixo para atualizar o navegador e carregar a extensão."
        }
      }
    },
    "taho": {
      "extension": {
        "step1": {
          "title": "Instale a extensão Taho",
          "description": "Recomendamos fixar o Taho na sua barra de tarefas para um acesso mais rápido à sua carteira."
        },
        "step2": {
          "title": "Criar ou Importar uma Carteira",
          "description": "Certifique-se de fazer o backup da sua carteira usando um método seguro. Nunca compartilhe sua frase secreta com ninguém."
        },
        "step3": {
          "title": "Atualize seu navegador",
          "description": "Depois de configurar sua carteira, clique abaixo para atualizar o navegador e carregar a extensão."
        }
      }
    },
    "wigwam": {
      "extension": {
        "step1": {
          "title": "Instale a extensão Wigwam",
          "description": "Recomendamos fixar o Wigwam na sua barra de tarefas para um acesso mais rápido à sua carteira."
        },
        "step2": {
          "title": "Criar ou Importar uma Carteira",
          "description": "Certifique-se de fazer backup de sua carteira usando um método seguro. Nunca compartilhe sua frase secreta com ninguém."
        },
        "step3": {
          "title": "Atualize seu navegador",
          "description": "Depois de configurar sua carteira, clique abaixo para atualizar o navegador e carregar a extensão."
        }
      }
    },
    "talisman": {
      "extension": {
        "step1": {
          "title": "Instale a extensão Talisman",
          "description": "Recomendamos fixar o Talisman na sua barra de tarefas para um acesso mais rápido à sua carteira."
        },
        "step2": {
          "title": "Crie ou Importe uma Carteira Ethereum",
          "description": "Certifique-se de fazer backup de sua carteira usando um método seguro. Nunca compartilhe sua frase de recuperação com ninguém."
        },
        "step3": {
          "title": "Atualize o seu navegador",
          "description": "Depois de configurar sua carteira, clique abaixo para atualizar o navegador e carregar a extensão."
        }
      }
    },
    "xdefi": {
      "extension": {
        "step1": {
          "title": "Instale a extensão XDEFI Wallet",
          "description": "Recomendamos fixar a Carteira XDEFI na sua barra de tarefas para um acesso mais rápido à sua carteira."
        },
        "step2": {
          "title": "Criar ou Importar uma Carteira",
          "description": "Certifique-se de fazer backup de sua carteira usando um método seguro. Nunca compartilhe sua frase secreta com ninguém."
        },
        "step3": {
          "title": "Atualize seu navegador",
          "description": "Depois de configurar sua carteira, clique abaixo para atualizar o navegador e carregar a extensão."
        }
      }
    },
    "zeal": {
      "qr_code": {
        "step1": {
          "title": "Abra o aplicativo Zeal",
          "description": "Adicione a Carteira Zeal à sua tela inicial para um acesso mais rápido à sua carteira."
        },
        "step2": {
          "title": "Criar ou Importar uma Carteira",
          "description": "Crie uma nova carteira ou importe uma existente."
        },
        "step3": {
          "title": "Toque no ícone do QR e escaneie",
          "description": "Toque no ícone QR na sua tela inicial, escaneie o código e confirme o prompt para conectar."
        }
      },
      "extension": {
        "step1": {
          "title": "Instale a extensão Zeal",
          "description": "Recomendamos fixar o Zeal na sua barra de tarefas para um acesso mais rápido à sua carteira."
        },
        "step2": {
          "title": "Criar ou Importar uma Carteira",
          "description": "Certifique-se de fazer backup de sua carteira usando um método seguro. Nunca compartilhe sua frase secreta com ninguém."
        },
        "step3": {
          "title": "Atualize seu navegador",
          "description": "Depois de configurar sua carteira, clique abaixo para atualizar o navegador e carregar a extensão."
        }
      }
    },
    "safepal": {
      "extension": {
        "step1": {
          "title": "Instale a extensão da Carteira SafePal",
          "description": "Clique no canto superior direito do seu navegador e fixe a Carteira SafePal para fácil acesso."
        },
        "step2": {
          "title": "Criar ou Importar uma carteira",
          "description": "Crie uma nova carteira ou importe uma existente."
        },
        "step3": {
          "title": "Atualize seu navegador",
          "description": "Depois de configurar a Carteira SafePal, clique abaixo para atualizar o navegador e carregar a extensão."
        }
      },
      "qr_code": {
        "step1": {
          "title": "Abra o aplicativo Carteira SafePal",
          "description": "Coloque a Carteira SafePal na tela inicial para um acesso mais rápido à sua carteira."
        },
        "step2": {
          "title": "Criar ou Importar uma Carteira",
          "description": "Crie uma nova carteira ou importe uma existente."
        },
        "step3": {
          "title": "Toque em WalletConnect nas Configurações",
          "description": "Escolha Nova Conexão, em seguida, escaneie o código QR e confirme o prompt para conectar."
        }
      }
    },
    "desig": {
      "extension": {
        "step1": {
          "title": "Instale a extensão Desig",
          "description": "Recomendamos fixar Desig na sua barra de tarefas para facilitar o acesso à sua carteira."
        },
        "step2": {
          "title": "Criar uma Carteira",
          "description": "Certifique-se de fazer backup de sua carteira usando um método seguro. Nunca compartilhe sua frase secreta com ninguém."
        },
        "step3": {
          "title": "Atualize seu navegador",
          "description": "Depois de configurar sua carteira, clique abaixo para atualizar o navegador e carregar a extensão."
        }
      }
    },
    "subwallet": {
      "extension": {
        "step1": {
          "title": "Instale a extensão SubWallet",
          "description": "Recomendamos fixar SubWallet na sua barra de tarefas para acesso mais rápido à sua carteira."
        },
        "step2": {
          "title": "Criar ou Importar uma Carteira",
          "description": "Certifique-se de fazer backup de sua carteira usando um método seguro. Nunca compartilhe sua frase de recuperação com ninguém."
        },
        "step3": {
          "title": "Atualize seu navegador",
          "description": "Depois de configurar sua carteira, clique abaixo para atualizar o navegador e carregar a extensão."
        }
      },
      "qr_code": {
        "step1": {
          "title": "Abra o aplicativo SubWallet",
          "description": "Recomendamos colocar SubWallet na tela inicial para acesso mais rápido."
        },
        "step2": {
          "title": "Criar ou Importar uma Carteira",
          "description": "Certifique-se de fazer backup de sua carteira usando um método seguro. Nunca compartilhe sua frase secreta com ninguém."
        },
        "step3": {
          "title": "Toque no botão de escanear",
          "description": "Depois que você escanear, um prompt de conexão aparecerá para você conectar sua carteira."
        }
      }
    },
    "clv": {
      "extension": {
        "step1": {
          "title": "Instale a extensão CLV Wallet",
          "description": "Recomendamos fixar CLV Wallet na sua barra de tarefas para acesso mais rápido à sua carteira."
        },
        "step2": {
          "title": "Criar ou Importar uma Carteira",
          "description": "Certifique-se de fazer backup de sua carteira usando um método seguro. Nunca compartilhe sua frase secreta com ninguém."
        },
        "step3": {
          "title": "Atualize seu navegador",
          "description": "Depois de configurar sua carteira, clique abaixo para atualizar o navegador e carregar a extensão."
        }
      },
      "qr_code": {
        "step1": {
          "title": "Abra o aplicativo da carteira CLV",
          "description": "Recomendamos colocar a Carteira CLV na tela inicial para acesso mais rápido."
        },
        "step2": {
          "title": "Criar ou Importar uma Carteira",
          "description": "Certifique-se de fazer backup de sua carteira usando um método seguro. Nunca compartilhe sua frase secreta com ninguém."
        },
        "step3": {
          "title": "Toque no botão de escanear",
          "description": "Depois que você escanear, um prompt de conexão aparecerá para você conectar sua carteira."
        }
      }
    },
    "okto": {
      "qr_code": {
        "step1": {
          "title": "Abra o aplicativo Okto",
          "description": "Adicione Okto à sua tela inicial para acesso rápido"
        },
        "step2": {
          "title": "Crie uma carteira MPC",
          "description": "Crie uma conta e gere uma carteira"
        },
        "step3": {
          "title": "Toque em WalletConnect nas Configurações",
          "description": "Toque no ícone Scan QR no canto superior direito e confirme o prompt para conectar."
        }
      }
    },
    "ledger": {
      "desktop": {
        "step1": {
          "title": "Abra o aplicativo Ledger Live",
          "description": "Recomendamos colocar o Ledger Live na tela inicial para um acesso mais rápido."
        },
        "step2": {
          "title": "Configure seu Ledger",
          "description": "Configure um novo Ledger ou conecte-se a um já existente."
        },
        "step3": {
          "title": "Conectar",
          "description": "Depois de escanear, aparecerá um prompt de conexão para você conectar sua carteira."
        }
      },
      "qr_code": {
        "step1": {
          "title": "Abra o aplicativo Ledger Live",
          "description": "Recomendamos colocar o Ledger Live na tela inicial para um acesso mais rápido."
        },
        "step2": {
          "title": "Configure seu Ledger",
          "description": "Você pode sincronizar com o aplicativo de desktop ou conectar seu Ledger."
        },
        "step3": {
          "title": "Escanear o código",
          "description": "Toque em WalletConnect e em seguida mude para Scanner. Depois de escanear, aparecerá um prompt de conexão para você conectar sua carteira."
        }
      }
    },
    "valora": {
      "qr_code": {
        "step1": {
          "title": "Abra o aplicativo Valora",
          "description": "Recomendamos colocar o Valora na tela inicial para um acesso mais rápido."
        },
        "step2": {
          "title": "Criar ou Importar uma carteira",
          "description": "Crie uma nova carteira ou importe uma existente."
        },
        "step3": {
          "title": "Toque no botão de escanear",
          "description": "Depois que você escanear, um prompt de conexão aparecerá para você conectar sua carteira."
        }
      }
    }
  }
}
`;export{a as default};
