var e=`{
  "connect_wallet": {
    "label": "Wallet verbinden",
    "wrong_network": {
      "label": "Falsches Netzwerk"
    }
  },
  "intro": {
    "title": "Was ist ein Wallet?",
    "description": "Ein Wallet wird verwendet, um digitale Assets zu senden, empfangen, speichern und anzeigen. Es ist auch eine neue Möglichkeit, sich anzumelden, ohne auf jeder Website neue Konten und Passwörter erstellen zu müssen.",
    "digital_asset": {
      "title": "Ein Zuhause für Ihre digitalen Vermögenswerte",
      "description": "Wallets werden verwendet, um digitale Assets wie Ethereum und NFTs zu senden, empfangen, speichern und anzeigen."
    },
    "login": {
      "title": "Eine neue Möglichkeit, sich anzumelden",
      "description": "Anstatt auf jeder Website neue Konten und Passwörter zu erstellen, verbinden Sie einfach Ihr Wallet."
    },
    "get": {
      "label": "Ein Wallet holen"
    },
    "learn_more": {
      "label": "Mehr erfahren"
    }
  },
  "sign_in": {
    "label": "Verifizieren Sie Ihr Konto",
    "description": "Um die Verbindung abzuschließen, müssen Sie eine Nachricht in Ihrem Wallet signieren, um zu verifizieren, dass Sie der Inhaber dieses Kontos sind.",
    "message": {
      "send": "Nachricht signieren",
      "preparing": "Nachricht wird vorbereitet...",
      "cancel": "Abbrechen",
      "preparing_error": "Fehler beim Vorbereiten der Nachricht, bitte erneut versuchen!"
    },
    "signature": {
      "waiting": "Warten auf Signatur...",
      "verifying": "Signatur wird überprüft...",
      "signing_error": "Fehler beim Signieren der Nachricht, bitte erneut versuchen!",
      "verifying_error": "Fehler bei der Überprüfung der Signatur, bitte erneut versuchen!",
      "oops_error": "Oops, etwas ist schiefgelaufen!"
    }
  },
  "connect": {
    "label": "Verbinden",
    "title": "Ein Wallet verbinden",
    "new_to_ethereum": {
      "description": "Neu bei Ethereum-Wallets?",
      "learn_more": {
        "label": "Mehr erfahren"
      }
    },
    "learn_more": {
      "label": "Mehr erfahren"
    },
    "recent": "Zuletzt",
    "status": {
      "opening": "%{wallet} wird geöffnet...",
      "connecting": "Verbinden",
      "connect_mobile": "Fahren Sie in %{wallet} fort",
      "not_installed": "%{wallet} ist nicht installiert",
      "not_available": "%{wallet} ist nicht verfügbar",
      "confirm": "Bestätigen Sie die Verbindung in der Erweiterung",
      "confirm_mobile": "Akzeptieren Sie die Verbindungsanfrage im Wallet"
    },
    "secondary_action": {
      "get": {
        "description": "Haben Sie kein %{wallet}?",
        "label": "HOLEN"
      },
      "install": {
        "label": "INSTALLIEREN"
      },
      "retry": {
        "label": "ERNEUT VERSUCHEN"
      }
    },
    "walletconnect": {
      "description": {
        "full": "Benötigen Sie das offizielle WalletConnect-Modul?",
        "compact": "Benötigen Sie das WalletConnect-Modul?"
      },
      "open": {
        "label": "ÖFFNEN"
      }
    }
  },
  "connect_scan": {
    "title": "Mit %{wallet} scannen",
    "fallback_title": "Mit Ihrem Telefon scannen"
  },
  "connector_group": {
    "installed": "Installiert",
    "recommended": "Empfohlen",
    "other": "Andere",
    "popular": "Beliebt",
    "more": "Mehr",
    "others": "Andere"
  },
  "get": {
    "title": "Ein Wallet holen",
    "action": {
      "label": "HOLEN"
    },
    "mobile": {
      "description": "Mobiles Wallet"
    },
    "extension": {
      "description": "Browser-Erweiterung"
    },
    "mobile_and_extension": {
      "description": "Mobiles Wallet und Erweiterung"
    },
    "mobile_and_desktop": {
      "description": "Mobile und Desktop Wallet"
    },
    "looking_for": {
      "title": "Nicht das, wonach Sie suchen?",
      "mobile": {
        "description": "Wählen Sie auf dem Hauptbildschirm ein Wallet aus, um mit einem anderen Wallet-Anbieter zu beginnen."
      },
      "desktop": {
        "compact_description": "Wählen Sie auf dem Hauptbildschirm ein Wallet aus, um mit einem anderen Wallet-Anbieter zu beginnen.",
        "wide_description": "Wählen Sie links ein Wallet aus, um mit einem anderen Wallet-Anbieter zu beginnen."
      }
    }
  },
  "get_options": {
    "title": "Beginnen Sie mit %{wallet}",
    "short_title": "%{wallet} besorgen",
    "mobile": {
      "title": "%{wallet} für Mobilgeräte",
      "description": "Verwenden Sie das mobile Wallet, um die Welt von Ethereum zu erkunden.",
      "download": {
        "label": "App herunterladen"
      }
    },
    "extension": {
      "title": "%{wallet} für %{browser}",
      "description": "Greifen Sie direkt von Ihrem bevorzugten Webbrowser auf Ihr Wallet zu.",
      "download": {
        "label": "Zu %{browser} hinzufügen"
      }
    },
    "desktop": {
      "title": "%{wallet} für %{platform}",
      "description": "Greifen Sie nativ von Ihrem leistungsstarken Desktop auf Ihr Wallet zu.",
      "download": {
        "label": "Hinzufügen zu %{platform}"
      }
    }
  },
  "get_mobile": {
    "title": "%{wallet} installieren",
    "description": "Scannen Sie mit Ihrem Telefon, um auf iOS oder Android herunterzuladen",
    "continue": {
      "label": "Fortfahren"
    }
  },
  "get_instructions": {
    "mobile": {
      "connect": {
        "label": "Verbinden"
      },
      "learn_more": {
        "label": "Mehr erfahren"
      }
    },
    "extension": {
      "refresh": {
        "label": "Aktualisieren"
      },
      "learn_more": {
        "label": "Mehr erfahren"
      }
    },
    "desktop": {
      "connect": {
        "label": "Verbinden"
      },
      "learn_more": {
        "label": "Mehr erfahren"
      }
    }
  },
  "chains": {
    "title": "Netzwerke wechseln",
    "wrong_network": "Falsches Netzwerk erkannt, wechseln oder trennen Sie die Verbindung, um fortzufahren.",
    "confirm": "Im Wallet bestätigen",
    "switching_not_supported": "Ihr Wallet unterstützt das Wechseln von Netzwerken von %{appName} aus nicht. Versuchen Sie stattdessen, innerhalb Ihres Wallets die Netzwerke zu wechseln.",
    "switching_not_supported_fallback": "Ihr Wallet unterstützt das Wechseln von Netzwerken von dieser App aus nicht. Versuchen Sie stattdessen, innerhalb Ihres Wallets die Netzwerke zu wechseln.",
    "disconnect": "Trennen",
    "connected": "Verbunden"
  },
  "profile": {
    "disconnect": {
      "label": "Trennen"
    },
    "copy_address": {
      "label": "Adresse kopieren",
      "copied": "Kopiert!"
    },
    "explorer": {
      "label": "Mehr im Explorer ansehen"
    },
    "transactions": {
      "description": "%{appName}-Transaktionen werden hier angezeigt...",
      "description_fallback": "Ihre Transaktionen werden hier angezeigt...",
      "recent": {
        "title": "Neueste Transaktionen"
      },
      "clear": {
        "label": "Alles löschen"
      }
    }
  },
  "wallet_connectors": {
    "argent": {
      "qr_code": {
        "step1": {
          "description": "Fügen Sie Argent zu Ihrem Startbildschirm hinzu, um schneller auf Ihr Wallet zuzugreifen.",
          "title": "Öffnen Sie die Argent-App"
        },
        "step2": {
          "description": "Erstellen Sie ein Wallet und einen Benutzernamen oder importieren Sie ein bestehendes Wallet.",
          "title": "Erstellen oder importieren Sie ein Wallet"
        },
        "step3": {
          "description": "Nach dem Scannen erscheint eine Verbindungsmeldung, um Ihr Wallet zu verbinden.",
          "title": "Tippen Sie auf die Schaltfläche QR-Scan"
        }
      }
    },
    "berasig": {
      "extension": {
        "step1": {
          "title": "Installieren Sie die BeraSig-Erweiterung",
          "description": "Wir empfehlen, BeraSig an die Taskleiste anzuheften, um leichter auf Ihre Brieftasche zuzugreifen."
        },
        "step2": {
          "title": "Erstellen Sie eine Wallet",
          "description": "Stellen Sie sicher, dass Sie Ihr Wallet mit einer sicheren Methode sichern. Teilen Sie niemals Ihre geheime Phrase mit jemandem."
        },
        "step3": {
          "title": "Aktualisieren Sie Ihren Browser",
          "description": "Sobald Sie Ihr Wallet eingerichtet haben, klicken Sie unten, um den Browser zu aktualisieren und die Erweiterung zu laden."
        }
      }
    },
    "best": {
      "qr_code": {
        "step1": {
          "title": "Öffnen Sie die Best Wallet-App",
          "description": "Fügen Sie die Best Wallet zu Ihrem Startbildschirm hinzu, um schneller auf Ihre Wallet zuzugreifen."
        },
        "step2": {
          "title": "Erstellen oder importieren Sie ein Wallet",
          "description": "Erstellen Sie ein neues Wallet oder importieren Sie ein bestehendes."
        },
        "step3": {
          "title": "Tippen Sie auf das QR-Symbol und scannen Sie",
          "description": "Tippen Sie auf das QR-Symbol auf Ihrem Startbildschirm, scannen Sie den Code und bestätigen Sie die Eingabeaufforderung, um die Verbindung herzustellen."
        }
      }
    },
    "bifrost": {
      "qr_code": {
        "step1": {
          "description": "Wir empfehlen, die Bifrost Wallet auf Ihren Startbildschirm zu legen, um schneller darauf zugreifen zu können.",
          "title": "Öffnen Sie die Bifrost Wallet-App"
        },
        "step2": {
          "description": "Erstellen oder importieren Sie ein Wallet mit Ihrer Wiederherstellungsphrase.",
          "title": "Erstellen oder importieren Sie ein Wallet"
        },
        "step3": {
          "description": "Nach dem Scannen erscheint eine Verbindungsmeldung, um Ihr Wallet zu verbinden.",
          "title": "Tippen Sie auf die Scan-Schaltfläche"
        }
      }
    },
    "bitget": {
      "qr_code": {
        "step1": {
          "description": "Wir empfehlen, die Bitget Wallet auf Ihren Startbildschirm zu legen, um schneller darauf zugreifen zu können.",
          "title": "Öffnen Sie die Bitget Wallet-App"
        },
        "step2": {
          "description": "Stellen Sie sicher, dass Sie Ihr Wallet mit einer sicheren Methode sichern. Teilen Sie niemals Ihre geheime Phrase mit jemandem.",
          "title": "Erstellen oder importieren Sie ein Wallet"
        },
        "step3": {
          "description": "Nach dem Scannen erscheint eine Verbindungsmeldung, um Ihr Wallet zu verbinden.",
          "title": "Tippen Sie auf die Scan-Schaltfläche"
        }
      },
      "extension": {
        "step1": {
          "description": "Wir empfehlen, die Bitget Wallet in Ihre Taskleiste zu heften, um schneller auf Ihr Wallet zugreifen zu können.",
          "title": "Installieren Sie die Bitget Wallet-Erweiterung"
        },
        "step2": {
          "description": "Stellen Sie sicher, dass Sie Ihr Wallet mit einer sicheren Methode sichern. Teilen Sie niemals Ihre geheime Phrase mit jemandem.",
          "title": "Erstellen oder importieren Sie ein Wallet"
        },
        "step3": {
          "description": "Sobald Sie Ihr Wallet eingerichtet haben, klicken Sie unten, um den Browser zu aktualisieren und die Erweiterung zu laden.",
          "title": "Aktualisieren Sie Ihren Browser"
        }
      }
    },
    "bitski": {
      "extension": {
        "step1": {
          "description": "Wir empfehlen, Bitski in Ihre Taskleiste zu heften, um schneller auf Ihr Wallet zugreifen zu können.",
          "title": "Installieren Sie die Bitski-Erweiterung"
        },
        "step2": {
          "description": "Stellen Sie sicher, dass Sie Ihr Wallet mit einer sicheren Methode sichern. Teilen Sie niemals Ihre geheime Phrase mit jemandem.",
          "title": "Erstellen oder importieren Sie ein Wallet"
        },
        "step3": {
          "description": "Sobald Sie Ihr Wallet eingerichtet haben, klicken Sie unten, um den Browser zu aktualisieren und die Erweiterung zu laden.",
          "title": "Aktualisieren Sie Ihren Browser"
        }
      }
    },
    "bitverse": {
      "qr_code": {
        "step1": {
          "title": "Öffnen Sie die Bitverse Wallet App",
          "description": "Fügen Sie die Bitverse Wallet Ihrem Startbildschirm hinzu, um schneller auf Ihr Wallet zuzugreifen."
        },
        "step2": {
          "title": "Erstellen oder importieren Sie ein Wallet",
          "description": "Erstellen Sie ein neues Wallet oder importieren Sie ein bestehendes."
        },
        "step3": {
          "title": "Tippen Sie auf das QR-Symbol und scannen Sie",
          "description": "Tippen Sie auf das QR-Symbol auf Ihrem Startbildschirm, scannen Sie den Code und bestätigen Sie die Eingabeaufforderung, um die Verbindung herzustellen."
        }
      }
    },
    "bloom": {
      "desktop": {
        "step1": {
          "title": "Öffnen Sie die Bloom Wallet-App",
          "description": "Wir empfehlen, Bloom Wallet auf Ihrem Startbildschirm abzulegen, um schneller darauf zugreifen zu können."
        },
        "step2": {
          "description": "Erstellen oder importieren Sie ein Wallet mit Ihrer Wiederherstellungsphrase.",
          "title": "Erstellen oder importieren Sie ein Wallet"
        },
        "step3": {
          "description": "Nachdem Sie ein Wallet haben, klicken Sie auf „Verbinden“, um über Bloom eine Verbindung herzustellen. Eine Verbindungsmeldung in der App wird angezeigt, um die Verbindung zu bestätigen.",
          "title": "Klicken Sie auf Verbinden"
        }
      }
    },
    "bybit": {
      "qr_code": {
        "step1": {
          "description": "Wir empfehlen, Bybit auf Ihrem Startbildschirm abzulegen, um schneller darauf zuzugreifen.",
          "title": "Öffnen Sie die Bybit App"
        },
        "step2": {
          "description": "Sie können Ihr Wallet ganz einfach mit unserer Backup-Funktion auf Ihrem Telefon sichern.",
          "title": "Erstellen oder importieren Sie ein Wallet"
        },
        "step3": {
          "description": "Nach dem Scannen erscheint eine Verbindungsmeldung, um Ihr Wallet zu verbinden.",
          "title": "Tippen Sie auf die Scan-Schaltfläche"
        }
      },
      "extension": {
        "step1": {
          "description": "Klicken Sie oben rechts in Ihrem Browser und heften Sie Bybit Wallet für einfachen Zugriff an.",
          "title": "Installieren Sie die Bybit Wallet Erweiterung"
        },
        "step2": {
          "description": "Erstellen Sie ein neues Wallet oder importieren Sie ein bestehendes.",
          "title": "Erstellen oder importieren Sie ein Wallet"
        },
        "step3": {
          "description": "Sobald Sie das Bybit Wallet eingerichtet haben, klicken Sie unten, um den Browser zu aktualisieren und die Erweiterung zu laden.",
          "title": "Aktualisieren Sie Ihren Browser"
        }
      }
    },
    "binance": {
      "qr_code": {
        "step1": {
          "description": "Wir empfehlen, Binance auf Ihrem Startbildschirm abzulegen, um schneller darauf zuzugreifen.",
          "title": "Öffnen Sie die Binance App"
        },
        "step2": {
          "description": "Sie können Ihr Wallet ganz einfach mit unserer Backup-Funktion auf Ihrem Telefon sichern.",
          "title": "Erstellen oder importieren Sie ein Wallet"
        },
        "step3": {
          "description": "Nach dem Scannen erscheint eine Verbindungsmeldung, um Ihr Wallet zu verbinden.",
          "title": "Tippen Sie auf die WalletConnect-Schaltfläche"
        }
      }
    },
    "coin98": {
      "qr_code": {
        "step1": {
          "description": "Wir empfehlen, die Coin98 Wallet auf Ihren Startbildschirm zu legen, um schneller darauf zugreifen zu können.",
          "title": "Öffnen Sie die Coin98 Wallet-App"
        },
        "step2": {
          "description": "Sie können Ihr Wallet ganz einfach mit unserer Backup-Funktion auf Ihrem Telefon sichern.",
          "title": "Erstellen oder importieren Sie ein Wallet"
        },
        "step3": {
          "description": "Nach dem Scannen erscheint eine Verbindungsmeldung, um Ihr Wallet zu verbinden.",
          "title": "Tippen Sie auf die WalletConnect-Schaltfläche"
        }
      },
      "extension": {
        "step1": {
          "description": "Klicken Sie oben rechts in Ihrem Browser und heften Sie die Coin98 Wallet an, um einen einfachen Zugriff zu ermöglichen.",
          "title": "Installieren Sie die Coin98 Wallet-Erweiterung"
        },
        "step2": {
          "description": "Erstellen Sie ein neues Wallet oder importieren Sie ein bestehendes.",
          "title": "Erstellen oder importieren Sie ein Wallet"
        },
        "step3": {
          "description": "Sobald Sie die Coin98 Wallet eingerichtet haben, klicken Sie unten, um den Browser zu aktualisieren und die Erweiterung zu laden.",
          "title": "Aktualisieren Sie Ihren Browser"
        }
      }
    },
    "coinbase": {
      "qr_code": {
        "step1": {
          "description": "Wir empfehlen, die Coinbase Wallet auf Ihren Startbildschirm zu legen, um schneller darauf zugreifen zu können.",
          "title": "Öffnen Sie die Coinbase Wallet-App"
        },
        "step2": {
          "description": "Sie können Ihr Wallet problemlos mit der Cloud-Backup-Funktion sichern.",
          "title": "Erstellen oder importieren Sie ein Wallet"
        },
        "step3": {
          "description": "Nach dem Scannen erscheint eine Verbindungsmeldung, um Ihr Wallet zu verbinden.",
          "title": "Tippen Sie auf die Scan-Schaltfläche"
        }
      },
      "extension": {
        "step1": {
          "description": "Wir empfehlen, die Coinbase Wallet in Ihre Taskleiste zu heften, um schneller auf Ihr Wallet zugreifen zu können.",
          "title": "Installieren Sie die Coinbase Wallet-Erweiterung"
        },
        "step2": {
          "description": "Stellen Sie sicher, dass Sie Ihr Wallet mit einer sicheren Methode sichern. Teilen Sie niemals Ihre geheime Phrase mit jemandem.",
          "title": "Erstellen oder importieren Sie ein Wallet"
        },
        "step3": {
          "description": "Sobald Sie Ihr Wallet eingerichtet haben, klicken Sie unten, um den Browser zu aktualisieren und die Erweiterung zu laden.",
          "title": "Aktualisieren Sie Ihren Browser"
        }
      }
    },
    "compass": {
      "extension": {
        "step1": {
          "description": "Wir empfehlen, die Compass Wallet an Ihre Taskleiste zu heften, um schneller auf Ihr Wallet zuzugreifen.",
          "title": "Installieren Sie die Compass Wallet Erweiterung"
        },
        "step2": {
          "description": "Stellen Sie sicher, dass Sie Ihr Wallet mit einer sicheren Methode sichern. Teilen Sie niemals Ihre geheime Phrase mit jemandem.",
          "title": "Erstellen oder importieren Sie ein Wallet"
        },
        "step3": {
          "description": "Sobald Sie Ihr Wallet eingerichtet haben, klicken Sie unten, um den Browser zu aktualisieren und die Erweiterung zu laden.",
          "title": "Aktualisieren Sie Ihren Browser"
        }
      }
    },
    "core": {
      "qr_code": {
        "step1": {
          "description": "Wir empfehlen, Core auf Ihren Startbildschirm zu legen, um schneller auf Ihr Wallet zuzugreifen.",
          "title": "Öffnen Sie die Core-App"
        },
        "step2": {
          "description": "Sie können Ihr Wallet ganz einfach mit unserer Backup-Funktion auf Ihrem Telefon sichern.",
          "title": "Erstellen oder importieren Sie ein Wallet"
        },
        "step3": {
          "description": "Nach dem Scannen erscheint eine Verbindungsmeldung, um Ihr Wallet zu verbinden.",
          "title": "Tippen Sie auf die WalletConnect-Schaltfläche"
        }
      },
      "extension": {
        "step1": {
          "description": "Wir empfehlen, Core an Ihre Taskleiste anzuheften, um schneller auf Ihr Wallet zugreifen zu können.",
          "title": "Installieren Sie die Core-Erweiterung"
        },
        "step2": {
          "description": "Stellen Sie sicher, dass Sie Ihr Wallet mit einer sicheren Methode sichern. Teilen Sie niemals Ihre geheime Phrase mit jemandem.",
          "title": "Erstellen oder importieren Sie ein Wallet"
        },
        "step3": {
          "description": "Sobald Sie Ihr Wallet eingerichtet haben, klicken Sie unten, um den Browser zu aktualisieren und die Erweiterung zu laden.",
          "title": "Aktualisieren Sie Ihren Browser"
        }
      }
    },
    "fox": {
      "qr_code": {
        "step1": {
          "description": "Wir empfehlen, FoxWallet auf Ihrem Startbildschirm zu platzieren, um schnelleren Zugriff zu erhalten.",
          "title": "Öffnen Sie die FoxWallet-App"
        },
        "step2": {
          "description": "Stellen Sie sicher, dass Sie Ihr Wallet mit einer sicheren Methode sichern. Teilen Sie niemals Ihre geheime Phrase mit jemandem.",
          "title": "Erstellen oder importieren Sie ein Wallet"
        },
        "step3": {
          "description": "Nach dem Scannen erscheint eine Verbindungsmeldung, um Ihr Wallet zu verbinden.",
          "title": "Tippen Sie auf die Scan-Schaltfläche"
        }
      }
    },
    "frontier": {
      "qr_code": {
        "step1": {
          "description": "Wir empfehlen, Frontier Wallet auf Ihrem Startbildschirm zu platzieren, um schnelleren Zugriff zu erhalten.",
          "title": "Öffnen Sie die Frontier Wallet-App"
        },
        "step2": {
          "description": "Stellen Sie sicher, dass Sie Ihr Wallet mit einer sicheren Methode sichern. Teilen Sie niemals Ihre geheime Phrase mit jemandem.",
          "title": "Erstellen oder importieren Sie ein Wallet"
        },
        "step3": {
          "description": "Nach dem Scannen erscheint eine Verbindungsmeldung, um Ihr Wallet zu verbinden.",
          "title": "Tippen Sie auf die Scan-Schaltfläche"
        }
      },
      "extension": {
        "step1": {
          "description": "Wir empfehlen, Frontier Wallet an Ihre Taskleiste anzuheften, um schneller auf Ihr Wallet zugreifen zu können.",
          "title": "Installieren Sie die Frontier Wallet-Erweiterung"
        },
        "step2": {
          "description": "Stellen Sie sicher, dass Sie Ihr Wallet mit einer sicheren Methode sichern. Teilen Sie niemals Ihre geheime Phrase mit jemandem.",
          "title": "Erstellen oder importieren Sie ein Wallet"
        },
        "step3": {
          "description": "Sobald Sie Ihr Wallet eingerichtet haben, klicken Sie unten, um den Browser zu aktualisieren und die Erweiterung zu laden.",
          "title": "Aktualisieren Sie Ihren Browser"
        }
      }
    },
    "im_token": {
      "qr_code": {
        "step1": {
          "title": "Öffnen Sie die imToken-App",
          "description": "Platzieren Sie die imToken-App auf Ihrem Startbildschirm für schnelleren Zugriff auf Ihr Wallet."
        },
        "step2": {
          "title": "Erstellen oder importieren Sie ein Wallet",
          "description": "Erstellen Sie ein neues Wallet oder importieren Sie ein bestehendes."
        },
        "step3": {
          "title": "Tippen Sie auf das Scanner-Symbol in der oberen rechten Ecke",
          "description": "Wählen Sie Neue Verbindung, dann scannen Sie den QR-Code und bestätigen Sie die Eingabeaufforderung, um die Verbindung herzustellen."
        }
      }
    },
    "iopay": {
      "qr_code": {
        "step1": {
          "description": "Wir empfehlen, ioPay auf Ihrem Startbildschirm abzulegen, um schneller darauf zuzugreifen.",
          "title": "Öffnen Sie die ioPay App"
        },
        "step2": {
          "description": "Sie können Ihr Wallet ganz einfach mit unserer Backup-Funktion auf Ihrem Telefon sichern.",
          "title": "Erstellen oder importieren Sie ein Wallet"
        },
        "step3": {
          "description": "Nach dem Scannen erscheint eine Verbindungsmeldung, um Ihr Wallet zu verbinden.",
          "title": "Tippen Sie auf die WalletConnect-Schaltfläche"
        }
      }
    },
    "kaikas": {
      "extension": {
        "step1": {
          "description": "Wir empfehlen, Kaikas an Ihre Taskleiste zu heften, um schneller auf Ihr Wallet zuzugreifen.",
          "title": "Installieren Sie die Kaikas Erweiterung"
        },
        "step2": {
          "description": "Stellen Sie sicher, dass Sie Ihr Wallet mit einer sicheren Methode sichern. Teilen Sie niemals Ihre geheime Phrase mit jemandem.",
          "title": "Erstellen oder importieren Sie ein Wallet"
        },
        "step3": {
          "description": "Sobald Sie Ihr Wallet eingerichtet haben, klicken Sie unten, um den Browser zu aktualisieren und die Erweiterung zu laden.",
          "title": "Aktualisieren Sie Ihren Browser"
        }
      },
      "qr_code": {
        "step1": {
          "title": "Öffnen Sie die Kaikas App",
          "description": "Legen Sie die Kaikas App auf Ihrem Startbildschirm ab, um schneller auf Ihr Wallet zuzugreifen."
        },
        "step2": {
          "title": "Erstellen oder importieren Sie ein Wallet",
          "description": "Erstellen Sie ein neues Wallet oder importieren Sie ein bestehendes."
        },
        "step3": {
          "title": "Tippen Sie auf das Scanner-Symbol in der oberen rechten Ecke",
          "description": "Wählen Sie Neue Verbindung, dann scannen Sie den QR-Code und bestätigen Sie die Eingabeaufforderung, um die Verbindung herzustellen."
        }
      }
    },
    "kaia": {
      "extension": {
        "step1": {
          "description": "Wir empfehlen, Kaia an Ihre Taskleiste zu heften, um schneller auf Ihr Wallet zuzugreifen.",
          "title": "Installieren Sie die Kaia Erweiterung"
        },
        "step2": {
          "description": "Stellen Sie sicher, dass Sie Ihr Wallet mit einer sicheren Methode sichern. Teilen Sie niemals Ihre geheime Phrase mit jemandem.",
          "title": "Erstellen oder importieren Sie ein Wallet"
        },
        "step3": {
          "description": "Sobald Sie Ihr Wallet eingerichtet haben, klicken Sie unten, um den Browser zu aktualisieren und die Erweiterung zu laden.",
          "title": "Aktualisieren Sie Ihren Browser"
        }
      },
      "qr_code": {
        "step1": {
          "title": "Öffnen Sie die Kaia-App",
          "description": "Legen Sie die Kaia-App auf Ihren Startbildschirm für schnelleren Zugriff auf Ihre Wallet."
        },
        "step2": {
          "title": "Erstellen oder importieren Sie ein Wallet",
          "description": "Erstellen Sie ein neues Wallet oder importieren Sie ein bestehendes."
        },
        "step3": {
          "title": "Tippen Sie auf das Scanner-Symbol in der oberen rechten Ecke",
          "description": "Wählen Sie Neue Verbindung, dann scannen Sie den QR-Code und bestätigen Sie die Eingabeaufforderung, um die Verbindung herzustellen."
        }
      }
    },
    "kraken": {
      "qr_code": {
        "step1": {
          "title": "Öffnen Sie die Kraken Wallet App",
          "description": "Fügen Sie die Kraken Wallet Ihrem Startbildschirm hinzu, um schneller auf Ihr Wallet zuzugreifen."
        },
        "step2": {
          "title": "Erstellen oder importieren Sie ein Wallet",
          "description": "Erstellen Sie ein neues Wallet oder importieren Sie ein bestehendes."
        },
        "step3": {
          "title": "Tippen Sie auf das QR-Symbol und scannen Sie",
          "description": "Tippen Sie auf das QR-Symbol auf Ihrem Startbildschirm, scannen Sie den Code und bestätigen Sie die Eingabeaufforderung, um die Verbindung herzustellen."
        }
      }
    },
    "kresus": {
      "qr_code": {
        "step1": {
          "title": "Öffnen Sie die Kresus Wallet App",
          "description": "Fügen Sie die Kresus Wallet Ihrem Startbildschirm hinzu, um schneller auf Ihr Wallet zuzugreifen."
        },
        "step2": {
          "title": "Erstellen oder importieren Sie ein Wallet",
          "description": "Erstellen Sie ein neues Wallet oder importieren Sie ein bestehendes."
        },
        "step3": {
          "title": "Tippen Sie auf das QR-Symbol und scannen Sie",
          "description": "Tippen Sie auf das QR-Symbol auf Ihrem Startbildschirm, scannen Sie den Code und bestätigen Sie die Eingabeaufforderung, um die Verbindung herzustellen."
        }
      }
    },
    "magicEden": {
      "extension": {
        "step1": {
          "title": "Installieren Sie die Magic Eden Erweiterung",
          "description": "Wir empfehlen, Magic Eden an Ihre Taskleiste zu heften, um einfacher auf Ihr Wallet zuzugreifen."
        },
        "step2": {
          "title": "Erstellen oder importieren Sie ein Wallet",
          "description": "Stellen Sie sicher, dass Sie Ihre Wallet auf sichere Weise sichern. Teilen Sie niemals Ihren geheimen Wiederherstellungssatz mit anderen."
        },
        "step3": {
          "title": "Aktualisieren Sie Ihren Browser",
          "description": "Sobald Sie Ihr Wallet eingerichtet haben, klicken Sie unten, um den Browser zu aktualisieren und die Erweiterung zu laden."
        }
      }
    },
    "metamask": {
      "qr_code": {
        "step1": {
          "title": "Öffnen Sie die MetaMask-App",
          "description": "Wir empfehlen, MetaMask auf Ihrem Startbildschirm zu platzieren, um schnelleren Zugriff zu erhalten."
        },
        "step2": {
          "title": "Erstellen oder importieren Sie ein Wallet",
          "description": "Stellen Sie sicher, dass Sie Ihr Wallet mit einer sicheren Methode sichern. Teilen Sie niemals Ihre geheime Phrase mit jemandem."
        },
        "step3": {
          "title": "Tippen Sie auf die Scan-Schaltfläche",
          "description": "Nach dem Scannen erscheint eine Verbindungsmeldung, um Ihr Wallet zu verbinden."
        }
      },
      "extension": {
        "step1": {
          "title": "Installieren Sie die MetaMask-Erweiterung",
          "description": "Wir empfehlen, MetaMask an Ihre Taskleiste anzuheften, um schneller auf Ihr Wallet zugreifen zu können."
        },
        "step2": {
          "title": "Erstellen oder importieren Sie ein Wallet",
          "description": "Stellen Sie sicher, dass Sie Ihr Wallet mit einer sicheren Methode sichern. Teilen Sie niemals Ihre geheime Phrase mit jemandem."
        },
        "step3": {
          "title": "Aktualisieren Sie Ihren Browser",
          "description": "Sobald Sie Ihr Wallet eingerichtet haben, klicken Sie unten, um den Browser zu aktualisieren und die Erweiterung zu laden."
        }
      }
    },
    "nestwallet": {
      "extension": {
        "step1": {
          "title": "Installieren Sie die NestWallet Erweiterung",
          "description": "Wir empfehlen, die NestWallet an Ihre Taskleiste zu heften, um schneller auf Ihr Wallet zuzugreifen."
        },
        "step2": {
          "title": "Erstellen oder importieren Sie ein Wallet",
          "description": "Stellen Sie sicher, dass Sie Ihr Wallet mit einer sicheren Methode sichern. Teilen Sie niemals Ihre geheime Phrase mit jemandem."
        },
        "step3": {
          "title": "Aktualisieren Sie Ihren Browser",
          "description": "Sobald Sie Ihr Wallet eingerichtet haben, klicken Sie unten, um den Browser zu aktualisieren und die Erweiterung zu laden."
        }
      }
    },
    "okx": {
      "qr_code": {
        "step1": {
          "title": "Öffnen Sie die OKX Wallet-App",
          "description": "Wir empfehlen, OKX Wallet auf Ihrem Startbildschirm zu platzieren, um schnelleren Zugriff zu erhalten."
        },
        "step2": {
          "title": "Erstellen oder importieren Sie ein Wallet",
          "description": "Stellen Sie sicher, dass Sie Ihr Wallet mit einer sicheren Methode sichern. Teilen Sie niemals Ihre geheime Phrase mit jemandem."
        },
        "step3": {
          "title": "Tippen Sie auf die Scan-Schaltfläche",
          "description": "Nach dem Scannen erscheint eine Verbindungsmeldung, um Ihr Wallet zu verbinden."
        }
      },
      "extension": {
        "step1": {
          "title": "Installieren Sie die OKX Wallet-Erweiterung",
          "description": "Wir empfehlen, OKX Wallet an Ihre Taskleiste anzuheften, um schneller auf Ihr Wallet zugreifen zu können."
        },
        "step2": {
          "title": "Erstellen oder importieren Sie ein Wallet",
          "description": "Stellen Sie sicher, dass Sie Ihr Wallet mit einer sicheren Methode sichern. Teilen Sie niemals Ihre geheime Phrase mit jemandem."
        },
        "step3": {
          "title": "Aktualisieren Sie Ihren Browser",
          "description": "Sobald Sie Ihr Wallet eingerichtet haben, klicken Sie unten, um den Browser zu aktualisieren und die Erweiterung zu laden."
        }
      }
    },
    "omni": {
      "qr_code": {
        "step1": {
          "title": "Öffnen Sie die Omni-App",
          "description": "Fügen Sie Omni Ihrem Startbildschirm hinzu, um schneller auf Ihr Wallet zuzugreifen."
        },
        "step2": {
          "title": "Erstellen oder importieren Sie ein Wallet",
          "description": "Erstellen Sie ein neues Wallet oder importieren Sie ein bestehendes."
        },
        "step3": {
          "title": "Tippen Sie auf das QR-Symbol und scannen Sie",
          "description": "Tippen Sie auf das QR-Symbol auf Ihrem Startbildschirm, scannen Sie den Code und bestätigen Sie die Eingabeaufforderung, um die Verbindung herzustellen."
        }
      }
    },
    "1inch": {
      "qr_code": {
        "step1": {
          "description": "Legen Sie die 1inch Wallet auf Ihrem Startbildschirm ab, um schneller auf Ihr Wallet zuzugreifen.",
          "title": "Öffnen Sie die 1inch Wallet App"
        },
        "step2": {
          "description": "Erstellen Sie ein Wallet und einen Benutzernamen oder importieren Sie ein bestehendes Wallet.",
          "title": "Erstellen oder importieren Sie ein Wallet"
        },
        "step3": {
          "description": "Nach dem Scannen erscheint eine Verbindungsmeldung, um Ihr Wallet zu verbinden.",
          "title": "Tippen Sie auf die Schaltfläche QR-Scan"
        }
      }
    },
    "token_pocket": {
      "qr_code": {
        "step1": {
          "title": "Öffnen Sie die TokenPocket-App",
          "description": "Wir empfehlen, TokenPocket auf Ihrem Startbildschirm zu platzieren, um schnelleren Zugriff zu erhalten."
        },
        "step2": {
          "title": "Erstellen oder importieren Sie ein Wallet",
          "description": "Stellen Sie sicher, dass Sie Ihr Wallet mit einer sicheren Methode sichern. Teilen Sie niemals Ihre geheime Phrase mit jemandem."
        },
        "step3": {
          "title": "Tippen Sie auf die Scan-Schaltfläche",
          "description": "Nach dem Scannen erscheint eine Verbindungsmeldung, um Ihr Wallet zu verbinden."
        }
      },
      "extension": {
        "step1": {
          "title": "Installieren Sie die TokenPocket-Erweiterung",
          "description": "Wir empfehlen, TokenPocket an Ihre Taskleiste anzuheften, um schneller auf Ihr Wallet zugreifen zu können."
        },
        "step2": {
          "title": "Erstellen oder importieren Sie ein Wallet",
          "description": "Stellen Sie sicher, dass Sie Ihr Wallet mit einer sicheren Methode sichern. Teilen Sie niemals Ihre geheime Phrase mit jemandem."
        },
        "step3": {
          "title": "Aktualisieren Sie Ihren Browser",
          "description": "Sobald Sie Ihr Wallet eingerichtet haben, klicken Sie unten, um den Browser zu aktualisieren und die Erweiterung zu laden."
        }
      }
    },
    "trust": {
      "qr_code": {
        "step1": {
          "title": "Öffnen Sie die Trust Wallet-App",
          "description": "Platzieren Sie Trust Wallet auf Ihrem Startbildschirm für schnelleren Zugriff auf Ihr Wallet."
        },
        "step2": {
          "title": "Erstellen oder importieren Sie ein Wallet",
          "description": "Erstellen Sie ein neues Wallet oder importieren Sie ein bestehendes."
        },
        "step3": {
          "title": "Tippen Sie auf WalletConnect in den Einstellungen",
          "description": "Wählen Sie Neue Verbindung, dann scannen Sie den QR-Code und bestätigen Sie die Eingabeaufforderung, um die Verbindung herzustellen."
        }
      },
      "extension": {
        "step1": {
          "title": "Installieren Sie die Trust Wallet-Erweiterung",
          "description": "Klicken Sie oben rechts in Ihrem Browser und pinnen Sie Trust Wallet für einfachen Zugriff."
        },
        "step2": {
          "title": "Erstellen oder importieren Sie ein Wallet",
          "description": "Erstellen Sie ein neues Wallet oder importieren Sie ein bestehendes."
        },
        "step3": {
          "title": "Aktualisieren Sie Ihren Browser",
          "description": "Sobald Sie Trust Wallet eingerichtet haben, klicken Sie unten, um den Browser zu aktualisieren und die Erweiterung zu laden."
        }
      }
    },
    "uniswap": {
      "qr_code": {
        "step1": {
          "title": "Öffnen Sie die Uniswap-App",
          "description": "Fügen Sie Uniswap Wallet Ihrem Startbildschirm hinzu, um schneller auf Ihr Wallet zuzugreifen."
        },
        "step2": {
          "title": "Erstellen oder importieren Sie ein Wallet",
          "description": "Erstellen Sie ein neues Wallet oder importieren Sie ein bestehendes."
        },
        "step3": {
          "title": "Tippen Sie auf das QR-Symbol und scannen Sie",
          "description": "Tippen Sie auf das QR-Symbol auf Ihrem Startbildschirm, scannen Sie den Code und bestätigen Sie die Eingabeaufforderung, um die Verbindung herzustellen."
        }
      }
    },
    "zerion": {
      "qr_code": {
        "step1": {
          "title": "Öffnen Sie die Zerion-App",
          "description": "Wir empfehlen, Zerion auf Ihrem Startbildschirm zu platzieren, um schnelleren Zugriff zu haben."
        },
        "step2": {
          "title": "Erstellen oder importieren Sie ein Wallet",
          "description": "Stellen Sie sicher, dass Sie Ihr Wallet mit einer sicheren Methode sichern. Teilen Sie niemals Ihre geheime Phrase mit jemandem."
        },
        "step3": {
          "title": "Tippen Sie auf die Scan-Schaltfläche",
          "description": "Nach dem Scannen erscheint eine Verbindungsmeldung, um Ihr Wallet zu verbinden."
        }
      },
      "extension": {
        "step1": {
          "title": "Installieren Sie die Zerion-Erweiterung",
          "description": "Wir empfehlen, Zerion an Ihre Taskleiste anzuheften, um schnelleren Zugriff auf Ihre Wallet zu haben."
        },
        "step2": {
          "title": "Erstellen oder importieren Sie ein Wallet",
          "description": "Stellen Sie sicher, dass Sie Ihr Wallet mit einer sicheren Methode sichern. Teilen Sie niemals Ihre geheime Phrase mit jemandem."
        },
        "step3": {
          "title": "Aktualisieren Sie Ihren Browser",
          "description": "Sobald Sie Ihr Wallet eingerichtet haben, klicken Sie unten, um den Browser zu aktualisieren und die Erweiterung zu laden."
        }
      }
    },
    "rainbow": {
      "qr_code": {
        "step1": {
          "title": "Öffnen Sie die Rainbow-App",
          "description": "Wir empfehlen, Rainbow auf Ihrem Startbildschirm zu platzieren, um schnelleren Zugriff auf Ihre Wallet zu haben."
        },
        "step2": {
          "title": "Erstellen oder importieren Sie ein Wallet",
          "description": "Sie können Ihr Wallet ganz einfach mit unserer Backup-Funktion auf Ihrem Telefon sichern."
        },
        "step3": {
          "title": "Tippen Sie auf die Scan-Schaltfläche",
          "description": "Nach dem Scannen erscheint eine Verbindungsmeldung, um Ihr Wallet zu verbinden."
        }
      }
    },
    "enkrypt": {
      "extension": {
        "step1": {
          "description": "Wir empfehlen, die Enkrypt Wallet an Ihre Taskleiste anzuheften, um schnelleren Zugriff auf Ihre Wallet zu haben.",
          "title": "Installieren Sie die Enkrypt Wallet-Erweiterung"
        },
        "step2": {
          "description": "Stellen Sie sicher, dass Sie Ihr Wallet mit einer sicheren Methode sichern. Teilen Sie niemals Ihre geheime Phrase mit jemandem.",
          "title": "Erstellen oder importieren Sie ein Wallet"
        },
        "step3": {
          "description": "Sobald Sie Ihr Wallet eingerichtet haben, klicken Sie unten, um den Browser zu aktualisieren und die Erweiterung zu laden.",
          "title": "Aktualisieren Sie Ihren Browser"
        }
      }
    },
    "frame": {
      "extension": {
        "step1": {
          "description": "Wir empfehlen, Frame an Ihre Taskleiste anzuheften, um schnelleren Zugriff auf Ihre Wallet zu haben.",
          "title": "Installieren Sie Frame und die zugehörige Erweiterung"
        },
        "step2": {
          "description": "Stellen Sie sicher, dass Sie Ihr Wallet mit einer sicheren Methode sichern. Teilen Sie niemals Ihre geheime Phrase mit jemandem.",
          "title": "Erstellen oder importieren Sie ein Wallet"
        },
        "step3": {
          "description": "Sobald Sie Ihr Wallet eingerichtet haben, klicken Sie unten, um den Browser zu aktualisieren und die Erweiterung zu laden.",
          "title": "Aktualisieren Sie Ihren Browser"
        }
      }
    },
    "one_key": {
      "extension": {
        "step1": {
          "title": "Installieren Sie die OneKey Wallet-Erweiterung",
          "description": "Wir empfehlen, die OneKey Wallet an Ihre Taskleiste anzuheften, um schnelleren Zugriff auf Ihre Wallet zu haben."
        },
        "step2": {
          "title": "Erstellen oder importieren Sie ein Wallet",
          "description": "Stellen Sie sicher, dass Sie Ihr Wallet mit einer sicheren Methode sichern. Teilen Sie niemals Ihre geheime Phrase mit jemandem."
        },
        "step3": {
          "title": "Aktualisieren Sie Ihren Browser",
          "description": "Sobald Sie Ihr Wallet eingerichtet haben, klicken Sie unten, um den Browser zu aktualisieren und die Erweiterung zu laden."
        }
      }
    },
    "paraswap": {
      "qr_code": {
        "step1": {
          "title": "Öffnen Sie die ParaSwap-App",
          "description": "Fügen Sie die ParaSwap Wallet zu Ihrem Startbildschirm hinzu, um schneller auf Ihre Wallet zuzugreifen."
        },
        "step2": {
          "title": "Erstellen oder importieren Sie ein Wallet",
          "description": "Erstellen Sie ein neues Wallet oder importieren Sie ein bestehendes."
        },
        "step3": {
          "title": "Tippen Sie auf das QR-Symbol und scannen Sie",
          "description": "Tippen Sie auf das QR-Symbol auf Ihrem Startbildschirm, scannen Sie den Code und bestätigen Sie die Eingabeaufforderung, um die Verbindung herzustellen."
        }
      }
    },
    "phantom": {
      "extension": {
        "step1": {
          "title": "Installieren Sie die Phantom-Erweiterung",
          "description": "Wir empfehlen, Phantom an Ihre Taskleiste anzuheften, um leichteren Zugriff auf Ihre Wallet zu haben."
        },
        "step2": {
          "title": "Erstellen oder importieren Sie ein Wallet",
          "description": "Stellen Sie sicher, dass Sie Ihre Wallet auf sichere Weise sichern. Teilen Sie niemals Ihren geheimen Wiederherstellungssatz mit anderen."
        },
        "step3": {
          "title": "Aktualisieren Sie Ihren Browser",
          "description": "Sobald Sie Ihr Wallet eingerichtet haben, klicken Sie unten, um den Browser zu aktualisieren und die Erweiterung zu laden."
        }
      }
    },
    "rabby": {
      "extension": {
        "step1": {
          "title": "Installieren Sie die Rabby-Erweiterung",
          "description": "Wir empfehlen, Rabby an Ihre Taskleiste anzuheften, um schnelleren Zugriff auf Ihre Wallet zu haben."
        },
        "step2": {
          "title": "Erstellen oder importieren Sie ein Wallet",
          "description": "Stellen Sie sicher, dass Sie Ihr Wallet mit einer sicheren Methode sichern. Teilen Sie niemals Ihre geheime Phrase mit jemandem."
        },
        "step3": {
          "title": "Aktualisieren Sie Ihren Browser",
          "description": "Sobald Sie Ihr Wallet eingerichtet haben, klicken Sie unten, um den Browser zu aktualisieren und die Erweiterung zu laden."
        }
      }
    },
    "ronin": {
      "qr_code": {
        "step1": {
          "description": "Wir empfehlen, die Ronin Wallet Ihrem Startbildschirm hinzuzufügen, um schneller darauf zuzugreifen.",
          "title": "Öffnen Sie die Ronin Wallet App"
        },
        "step2": {
          "description": "Stellen Sie sicher, dass Sie Ihr Wallet mit einer sicheren Methode sichern. Teilen Sie niemals Ihre geheime Phrase mit jemandem.",
          "title": "Erstellen oder importieren Sie ein Wallet"
        },
        "step3": {
          "description": "Nach dem Scannen erscheint eine Verbindungsmeldung, um Ihr Wallet zu verbinden.",
          "title": "Tippen Sie auf die Scan-Schaltfläche"
        }
      },
      "extension": {
        "step1": {
          "description": "Wir empfehlen, die Ronin Wallet an Ihre Taskleiste zu heften, um schneller darauf zuzugreifen.",
          "title": "Installieren Sie die Ronin Wallet Erweiterung"
        },
        "step2": {
          "description": "Stellen Sie sicher, dass Sie Ihr Wallet mit einer sicheren Methode sichern. Teilen Sie niemals Ihre geheime Phrase mit jemandem.",
          "title": "Erstellen oder importieren Sie ein Wallet"
        },
        "step3": {
          "description": "Sobald Sie Ihr Wallet eingerichtet haben, klicken Sie unten, um den Browser zu aktualisieren und die Erweiterung zu laden.",
          "title": "Aktualisieren Sie Ihren Browser"
        }
      }
    },
    "ramper": {
      "extension": {
        "step1": {
          "title": "Installieren Sie die Ramper Erweiterung",
          "description": "Wir empfehlen, Ramper an Ihre Taskleiste zu heften, um einfacher darauf zugreifen zu können."
        },
        "step2": {
          "title": "Erstellen Sie eine Wallet",
          "description": "Stellen Sie sicher, dass Sie Ihr Wallet mit einer sicheren Methode sichern. Teilen Sie niemals Ihre geheime Phrase mit jemandem."
        },
        "step3": {
          "title": "Aktualisieren Sie Ihren Browser",
          "description": "Sobald Sie Ihr Wallet eingerichtet haben, klicken Sie unten, um den Browser zu aktualisieren und die Erweiterung zu laden."
        }
      }
    },
    "safeheron": {
      "extension": {
        "step1": {
          "title": "Installieren Sie die Core-Erweiterung",
          "description": "Wir empfehlen, Safeheron an Ihre Taskleiste anzuheften, um schnelleren Zugriff auf Ihre Wallet zu haben."
        },
        "step2": {
          "title": "Erstellen oder importieren Sie ein Wallet",
          "description": "Stellen Sie sicher, dass Sie Ihr Wallet mit einer sicheren Methode sichern. Teilen Sie niemals Ihre geheime Phrase mit jemandem."
        },
        "step3": {
          "title": "Aktualisieren Sie Ihren Browser",
          "description": "Sobald Sie Ihr Wallet eingerichtet haben, klicken Sie unten, um den Browser zu aktualisieren und die Erweiterung zu laden."
        }
      }
    },
    "taho": {
      "extension": {
        "step1": {
          "title": "Installieren Sie die Taho-Erweiterung",
          "description": "Wir empfehlen, Taho an Ihre Taskleiste anzuheften, um schnelleren Zugriff auf Ihre Wallet zu haben."
        },
        "step2": {
          "title": "Erstellen oder importieren Sie ein Wallet",
          "description": "Stellen Sie sicher, dass Sie Ihr Wallet mit einer sicheren Methode sichern. Teilen Sie niemals Ihre geheime Phrase mit jemandem."
        },
        "step3": {
          "title": "Aktualisieren Sie Ihren Browser",
          "description": "Sobald Sie Ihr Wallet eingerichtet haben, klicken Sie unten, um den Browser zu aktualisieren und die Erweiterung zu laden."
        }
      }
    },
    "wigwam": {
      "extension": {
        "step1": {
          "title": "Installieren Sie die Wigwam-Erweiterung",
          "description": "Wir empfehlen, Wigwam an Ihre Taskleiste anzuheften, um einen schnelleren Zugriff auf Ihr Wallet zu ermöglichen."
        },
        "step2": {
          "title": "Erstellen oder importieren Sie ein Wallet",
          "description": "Stellen Sie sicher, dass Sie Ihr Wallet mit einer sicheren Methode sichern. Teilen Sie niemals Ihre geheime Phrase mit jemandem."
        },
        "step3": {
          "title": "Aktualisieren Sie Ihren Browser",
          "description": "Sobald Sie Ihr Wallet eingerichtet haben, klicken Sie unten, um den Browser zu aktualisieren und die Erweiterung zu laden."
        }
      }
    },
    "talisman": {
      "extension": {
        "step1": {
          "title": "Installieren Sie die Talisman-Erweiterung",
          "description": "Wir empfehlen, Talisman an Ihre Taskleiste anzuheften, um schnelleren Zugriff auf Ihre Wallet zu haben."
        },
        "step2": {
          "title": "Erstellen oder Importieren Sie eine Ethereum-Wallet",
          "description": "Stellen Sie sicher, dass Sie Ihre Wallet auf sichere Weise sichern. Teilen Sie niemals Ihre Wiederherstellungsphrase mit anderen."
        },
        "step3": {
          "title": "Aktualisieren Sie Ihren Browser",
          "description": "Sobald Sie Ihr Wallet eingerichtet haben, klicken Sie unten, um den Browser zu aktualisieren und die Erweiterung zu laden."
        }
      }
    },
    "xdefi": {
      "extension": {
        "step1": {
          "title": "Installieren Sie die XDEFI Wallet-Erweiterung",
          "description": "Wir empfehlen, die XDEFI Wallet an Ihre Taskleiste anzuheften, um schnelleren Zugriff auf Ihre Wallet zu haben."
        },
        "step2": {
          "title": "Erstellen oder importieren Sie ein Wallet",
          "description": "Stellen Sie sicher, dass Sie Ihr Wallet mit einer sicheren Methode sichern. Teilen Sie niemals Ihre geheime Phrase mit jemandem."
        },
        "step3": {
          "title": "Aktualisieren Sie Ihren Browser",
          "description": "Sobald Sie Ihr Wallet eingerichtet haben, klicken Sie unten, um den Browser zu aktualisieren und die Erweiterung zu laden."
        }
      }
    },
    "zeal": {
      "qr_code": {
        "step1": {
          "title": "Öffnen Sie die Zeal App",
          "description": "Fügen Sie die Zeal Wallet Ihrem Startbildschirm hinzu, um schneller auf Ihr Wallet zuzugreifen."
        },
        "step2": {
          "title": "Erstellen oder importieren Sie ein Wallet",
          "description": "Erstellen Sie ein neues Wallet oder importieren Sie ein bestehendes."
        },
        "step3": {
          "title": "Tippen Sie auf das QR-Symbol und scannen Sie",
          "description": "Tippen Sie auf das QR-Symbol auf Ihrem Startbildschirm, scannen Sie den Code und bestätigen Sie die Eingabeaufforderung, um die Verbindung herzustellen."
        }
      },
      "extension": {
        "step1": {
          "title": "Installieren Sie die Zeal-Erweiterung",
          "description": "Wir empfehlen, Zeal an Ihre Taskleiste anzuheften, um schnelleren Zugriff auf Ihre Wallet zu haben."
        },
        "step2": {
          "title": "Erstellen oder importieren Sie ein Wallet",
          "description": "Stellen Sie sicher, dass Sie Ihr Wallet mit einer sicheren Methode sichern. Teilen Sie niemals Ihre geheime Phrase mit jemandem."
        },
        "step3": {
          "title": "Aktualisieren Sie Ihren Browser",
          "description": "Sobald Sie Ihr Wallet eingerichtet haben, klicken Sie unten, um den Browser zu aktualisieren und die Erweiterung zu laden."
        }
      }
    },
    "safepal": {
      "extension": {
        "step1": {
          "title": "Installieren Sie die SafePal Wallet-Erweiterung",
          "description": "Klicken Sie oben rechts in Ihrem Browser und heften Sie SafePal Wallet für einfachen Zugriff an."
        },
        "step2": {
          "title": "Erstellen oder importieren Sie ein Wallet",
          "description": "Erstellen Sie ein neues Wallet oder importieren Sie ein bestehendes."
        },
        "step3": {
          "title": "Aktualisieren Sie Ihren Browser",
          "description": "Sobald Sie die SafePal Wallet eingerichtet haben, klicken Sie unten, um den Browser zu aktualisieren und die Erweiterung zu laden."
        }
      },
      "qr_code": {
        "step1": {
          "title": "Öffnen Sie die SafePal Wallet-App",
          "description": "Platzieren Sie SafePal Wallet auf Ihrem Startbildschirm, um schnelleren Zugriff auf Ihre Wallet zu haben."
        },
        "step2": {
          "title": "Erstellen oder importieren Sie ein Wallet",
          "description": "Erstellen Sie ein neues Wallet oder importieren Sie ein bestehendes."
        },
        "step3": {
          "title": "Tippen Sie auf WalletConnect in den Einstellungen",
          "description": "Wählen Sie Neue Verbindung, dann scannen Sie den QR-Code und bestätigen Sie die Eingabeaufforderung, um die Verbindung herzustellen."
        }
      }
    },
    "desig": {
      "extension": {
        "step1": {
          "title": "Installieren Sie die Desig-Erweiterung",
          "description": "Wir empfehlen, Desig an Ihre Taskleiste anzuheften, um leichteren Zugriff auf Ihre Wallet zu haben."
        },
        "step2": {
          "title": "Erstellen Sie eine Wallet",
          "description": "Stellen Sie sicher, dass Sie Ihr Wallet mit einer sicheren Methode sichern. Teilen Sie niemals Ihre geheime Phrase mit jemandem."
        },
        "step3": {
          "title": "Aktualisieren Sie Ihren Browser",
          "description": "Sobald Sie Ihr Wallet eingerichtet haben, klicken Sie unten, um den Browser zu aktualisieren und die Erweiterung zu laden."
        }
      }
    },
    "subwallet": {
      "extension": {
        "step1": {
          "title": "Installieren Sie die SubWallet-Erweiterung",
          "description": "Wir empfehlen, SubWallet an Ihre Taskleiste zu heften, um schneller auf Ihr Wallet zugreifen zu können."
        },
        "step2": {
          "title": "Erstellen oder importieren Sie ein Wallet",
          "description": "Stellen Sie sicher, dass Sie Ihre Wallet auf sichere Weise sichern. Teilen Sie niemals Ihre Wiederherstellungsphrase mit anderen."
        },
        "step3": {
          "title": "Aktualisieren Sie Ihren Browser",
          "description": "Sobald Sie Ihr Wallet eingerichtet haben, klicken Sie unten, um den Browser zu aktualisieren und die Erweiterung zu laden."
        }
      },
      "qr_code": {
        "step1": {
          "title": "Öffnen Sie die SubWallet-App",
          "description": "Wir empfehlen, SubWallet auf Ihrem Startbildschirm abzulegen, um schneller darauf zugreifen zu können."
        },
        "step2": {
          "title": "Erstellen oder importieren Sie ein Wallet",
          "description": "Stellen Sie sicher, dass Sie Ihr Wallet mit einer sicheren Methode sichern. Teilen Sie niemals Ihre geheime Phrase mit jemandem."
        },
        "step3": {
          "title": "Tippen Sie auf die Scan-Schaltfläche",
          "description": "Nach dem Scannen erscheint eine Verbindungsmeldung, um Ihr Wallet zu verbinden."
        }
      }
    },
    "clv": {
      "extension": {
        "step1": {
          "title": "Installieren Sie die CLV Wallet-Erweiterung",
          "description": "Wir empfehlen, CLV Wallet an Ihre Taskleiste zu heften, um schneller auf Ihr Wallet zugreifen zu können."
        },
        "step2": {
          "title": "Erstellen oder importieren Sie ein Wallet",
          "description": "Stellen Sie sicher, dass Sie Ihr Wallet mit einer sicheren Methode sichern. Teilen Sie niemals Ihre geheime Phrase mit jemandem."
        },
        "step3": {
          "title": "Aktualisieren Sie Ihren Browser",
          "description": "Sobald Sie Ihr Wallet eingerichtet haben, klicken Sie unten, um den Browser zu aktualisieren und die Erweiterung zu laden."
        }
      },
      "qr_code": {
        "step1": {
          "title": "Öffnen Sie die CLV Wallet-App",
          "description": "Wir empfehlen, CLV Wallet auf Ihrem Startbildschirm abzulegen, um schneller darauf zugreifen zu können."
        },
        "step2": {
          "title": "Erstellen oder importieren Sie ein Wallet",
          "description": "Stellen Sie sicher, dass Sie Ihr Wallet mit einer sicheren Methode sichern. Teilen Sie niemals Ihre geheime Phrase mit jemandem."
        },
        "step3": {
          "title": "Tippen Sie auf die Scan-Schaltfläche",
          "description": "Nach dem Scannen erscheint eine Verbindungsmeldung, um Ihr Wallet zu verbinden."
        }
      }
    },
    "okto": {
      "qr_code": {
        "step1": {
          "title": "Öffnen Sie die Okto-App",
          "description": "Fügen Sie Okto Ihrem Startbildschirm hinzu, um schnellen Zugriff zu erhalten"
        },
        "step2": {
          "title": "Erstellen Sie ein MPC-Wallet",
          "description": "Erstellen Sie ein Konto und generieren Sie ein Wallet"
        },
        "step3": {
          "title": "Tippen Sie auf WalletConnect in den Einstellungen",
          "description": "Tippen Sie auf das QR-Scan-Symbol oben rechts und bestätigen Sie die Aufforderung zum Verbinden."
        }
      }
    },
    "ledger": {
      "desktop": {
        "step1": {
          "title": "Öffnen Sie die Ledger Live-App",
          "description": "Wir empfehlen, Ledger Live auf Ihrem Startbildschirm abzulegen, um schneller darauf zugreifen zu können."
        },
        "step2": {
          "title": "Richten Sie Ihr Ledger ein",
          "description": "Richten Sie ein neues Ledger ein oder verbinden Sie sich mit einem bestehenden."
        },
        "step3": {
          "title": "Verbinden",
          "description": "Eine Verbindungsmeldung erscheint, um Ihr Wallet zu verbinden."
        }
      },
      "qr_code": {
        "step1": {
          "title": "Öffnen Sie die Ledger Live-App",
          "description": "Wir empfehlen, Ledger Live auf Ihrem Startbildschirm abzulegen, um schneller darauf zugreifen zu können."
        },
        "step2": {
          "title": "Richten Sie Ihr Ledger ein",
          "description": "Sie können entweder mit der Desktop-App synchronisieren oder Ihr Ledger verbinden."
        },
        "step3": {
          "title": "Code scannen",
          "description": "Tippen Sie auf WalletConnect und wechseln Sie dann zum Scanner. Nach dem Scannen erscheint eine Verbindungsmeldung, um Ihr Wallet zu verbinden."
        }
      }
    },
    "valora": {
      "qr_code": {
        "step1": {
          "title": "Öffnen Sie die Valora-App",
          "description": "Wir empfehlen, Valora für einen schnelleren Zugriff auf Ihrem Startbildschirm zu platzieren."
        },
        "step2": {
          "title": "Erstellen oder importieren Sie eine Wallet",
          "description": "Erstellen Sie ein neues Wallet oder importieren Sie ein bestehendes."
        },
        "step3": {
          "title": "Tippen Sie auf die Scan-Schaltfläche",
          "description": "Nach dem Scannen erscheint eine Verbindungsmeldung, um Ihr Wallet zu verbinden."
        }
      }
    }
  }
}
`;export{e as default};
