# VeRomTec Token Site (PHP wrapper) + Recipe palette

This package keeps **all the original functionality** from the uploaded VeRomTec token web build (the JS app in `assets/`).

What changed:
- Served via **PHP front controller** (`index.php`) so you can host it on a PHP server.
- Added `theme-overrides.css` to apply the **same color palette** as your recipe web (dark + green accent).
- Added `favicon.ico` (generated from the included `favicon.png`).
- Added SPA routing rules:
  - `.htaccess` for Apache
  - `router.php` for `php -S`

## Run locally

```bash
php -S localhost:8080 router.php
```
Open:
- http://localhost:8080/

## Deploy (Apache)
- Upload all files to your web root.
- Make sure `mod_rewrite` is enabled.
- `.htaccess` will route all paths to `index.php` so React/Web3 routes work.

## Deploy (Nginx)
Use a typical SPA fallback:

```
location / {
  try_files $uri $uri/ /index.php?$query_string;
}
```

## Editing the palette
Open `theme-overrides.css` and adjust:
- `--bg-body`, `--bg-surface`, `--accent`

